/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemEngineerGoggles;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserWrench;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RenderLaserRelay
implements BlockEntityRenderer<TileEntityLaserRelay> {
    private static final int COLOR = 0xFF0000;
    private static final int COLOR_ITEM = 31760;
    private static final int COLOR_FLUIDS = 25030;
    private static final int COLOR_INFRARED = 13743087;

    public RenderLaserRelay(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityLaserRelay tile, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ConcurrentSet<IConnectionPair> connections;
        TileEntityLaserRelay relay = tile;
        BlockState state = tile.m_58900_();
        boolean hasInvis = false;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean hasGoggles = ItemEngineerGoggles.isWearing((Player)player);
        ItemStack upgrade = relay.inv.getStackInSlot(0);
        if (StackUtil.isValid(upgrade)) {
            if (upgrade.m_41720_() == ActuallyItems.LASER_UPGRADE_INVISIBILITY.get()) {
                hasInvis = true;
            }
            ItemStack hand = player.m_21205_();
            if (hasGoggles || StackUtil.isValid(hand) && (hand.m_41720_() == CommonConfig.Other.relayConfigureItem || hand.m_41720_() instanceof ItemLaserWrench) || "themattabase".equals(player.m_7755_().getString())) {
                matrices.m_85836_();
                Direction direction = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.UP;
                float yTrans = direction.m_122434_() == Direction.Axis.Y ? 0.2f : 0.8f;
                matrices.m_252880_(0.5f, yTrans, 0.5f);
                matrices.m_85841_(0.2f, 0.2f, 0.2f);
                double boop = (double)Util.m_137550_() / 800.0;
                matrices.m_252781_(Axis.f_252436_.m_252977_((float)(boop * 40.0 % 360.0)));
                AssetUtil.renderItemInWorld(upgrade, combinedLight, combinedOverlay, matrices, buffer);
                matrices.m_85849_();
            }
        }
        if ((connections = tile.getConnections()) != null && !connections.isEmpty()) {
            for (IConnectionPair pair : connections) {
                boolean otherInvis;
                if (pair.doesSuppressRender() || !tile.m_58899_().equals((Object)pair.getPositions()[0])) continue;
                BlockPos first = tile.m_58899_();
                BlockPos second = pair.getPositions()[1];
                BlockEntity secondTile = tile.m_58904_().m_7702_(second);
                if (!(secondTile instanceof TileEntityLaserRelay)) continue;
                ItemStack secondUpgrade = ((TileEntityLaserRelay)secondTile).inv.getStackInSlot(0);
                boolean bl = otherInvis = StackUtil.isValid(secondUpgrade) && secondUpgrade.m_41720_() == ActuallyItems.LASER_UPGRADE_INVISIBILITY.get();
                if (!hasGoggles && hasInvis && otherInvis) continue;
                int color = hasInvis && otherInvis ? 13743087 : (relay.type == LaserType.ITEM ? 31760 : (relay.type == LaserType.FLUID ? 25030 : 0xFF0000));
                BlockPos offsetStart = first.m_121996_((Vec3i)tile.m_58899_());
                BlockPos offsetEnd = second.m_121996_((Vec3i)tile.m_58899_());
                offsetEnd = offsetEnd.m_7954_(Rotation.CLOCKWISE_90);
                matrices.m_85836_();
                AssetUtil.renderLaser(matrices, buffer, new Vec3((double)offsetStart.m_123341_(), (double)offsetStart.m_123342_(), (double)offsetStart.m_123343_()), new Vec3((double)offsetEnd.m_123341_(), (double)offsetEnd.m_123342_(), (double)offsetEnd.m_123343_()), 120.0f, color, hasInvis && otherInvis ? 0.1f : 0.35f, 0.05f);
                matrices.m_85849_();
            }
        }
    }

    public boolean shouldRenderOffScreen(TileEntityLaserRelay tile) {
        return true;
    }

    public int m_142163_() {
        return 32;
    }
}

