/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.ItemBattery;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBatteryBox;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.Lang;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderBatteryBox
implements BlockEntityRenderer<TileEntityBatteryBox> {
    public RenderBatteryBox(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityBatteryBox tile, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack stack = tile.inv.getStackInSlot(0);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemBattery)) {
            return;
        }
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.35f, 0.5f);
        matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        matrices.m_85836_();
        matrices.m_85841_(0.0075f, 0.0075f, 0.0075f);
        matrices.m_252880_(0.0f, 0.0f, -60.0f);
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> {
            Font font = Minecraft.m_91087_().f_91062_;
            String energyTotal = Lang.cleanEnergyValues(cap, false);
            MutableComponent energyName = Component.m_237115_((String)"misc.actuallyadditions.power_name_long");
            float backgroundOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(backgroundOpacity * 255.0f) << 24;
            for (int i = 0; i < 4; ++i) {
                Matrix4f pose = matrices.m_85850_().m_252922_();
                font.m_271703_(energyTotal, (float)(-font.m_92895_(energyTotal)) / 2.0f, 10.0f, 0xFFFFFF, false, pose, buffer, Font.DisplayMode.NORMAL, j, combinedLight);
                font.m_272077_((Component)energyName, (float)(-font.m_92852_((FormattedText)energyName)) / 2.0f, 20.0f, 0xFFFFFF, false, pose, buffer, Font.DisplayMode.NORMAL, j, combinedLight);
                matrices.m_252880_(-60.0f, 0.0f, 60.0f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
        });
        matrices.m_85849_();
        matrices.m_85849_();
        double boop = (double)Util.m_137550_() / 800.0;
        float scale = stack.m_41720_() instanceof BlockItem ? 0.85f : 0.65f;
        matrices.m_85836_();
        matrices.m_85837_(0.5, 1.0 + Math.sin(boop % (Math.PI * 2)) * 0.065, 0.5);
        matrices.m_252781_(Axis.f_252436_.m_252977_((float)(boop * 40.0 % 360.0)));
        matrices.m_85841_(scale, scale, scale);
        try {
            AssetUtil.renderItemInWorld(stack, combinedLight, combinedOverlay, matrices, buffer);
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.error("Something went wrong trying to render an item in a battery box! The item is " + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()) + "!", (Throwable)e);
        }
        matrices.m_85849_();
    }
}

