/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;

public abstract class BlockContainerBase
extends Block
implements EntityBlock {
    public BlockContainerBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult openGui(Level world, Player player, BlockPos pos, Class<? extends MenuProvider> expectedInstance) {
        if (!world.f_46443_) {
            BlockEntity tile = world.m_7702_(pos);
            if (expectedInstance.isInstance(tile)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tile), (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void dropInventory(Level world, BlockPos position) {
        BlockEntity aTile;
        if (!world.f_46443_ && (aTile = world.m_7702_(position)) instanceof TileEntityInventoryBase) {
            TileEntityInventoryBase tile = (TileEntityInventoryBase)aTile;
            if (tile.inv.getSlots() > 0) {
                for (int i = 0; i < tile.inv.getSlots(); ++i) {
                    this.dropSlotFromInventory(i, tile, world, position);
                }
            }
        }
    }

    private void dropSlotFromInventory(int i, TileEntityInventoryBase tile, Level world, BlockPos pos) {
        ItemStack stack = tile.inv.getStackInSlot(i);
        if (stack.m_41619_()) {
            return;
        }
        float dX = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        float dY = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        float dZ = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.m_123341_() + dX), (double)((float)pos.m_123342_() + dY), (double)((float)pos.m_123343_() + dZ), stack.m_41777_());
        float factor = 0.05f;
        entityItem.m_5997_(world.f_46441_.m_188583_() * (double)factor, world.f_46441_.m_188583_() * (double)factor + (double)0.2f, world.f_46441_.m_188583_() * (double)factor);
        world.m_7967_((Entity)entityItem);
    }

    public boolean tryToggleRedstone(Level world, BlockPos pos, Player player) {
        BlockEntity tile;
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == CommonConfig.Other.redstoneConfigureItem && (tile = world.m_7702_(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            if (!world.f_46443_ && base.isRedstoneToggle()) {
                base.isPulseMode = !base.isPulseMode;
                base.m_6596_();
                base.sendUpdate();
            }
            return true;
        }
        return false;
    }

    public void m_213897_(@Nonnull BlockState state, ServerLevel world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        TileEntityBase base;
        BlockEntity tile;
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof TileEntityBase && (base = (TileEntityBase)tile).respondsToPulses()) {
            base.activateOnPulse();
        }
    }

    public void neighborsChangedCustom(Level world, BlockPos pos) {
        TileEntityBase base;
        this.updateRedstoneState(world, pos);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityBase && (base = (TileEntityBase)tile).shouldSaveDataOnChangeOrWorldStart()) {
            base.saveDataOnChangeOrWorldStart();
        }
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        this.neighborsChangedCustom(worldIn, pos);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof Level) {
            this.neighborsChangedCustom((Level)world, pos);
        }
    }

    public void updateRedstoneState(Level world, BlockPos pos) {
        BlockEntity tile;
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            boolean powered = world.m_277086_(pos) > 0;
            boolean wasPowered = base.isRedstonePowered;
            if (powered && !wasPowered) {
                if (base.respondsToPulses()) {
                    base.activateOnPulse();
                }
                base.setRedstonePowered(true);
            } else if (!powered && wasPowered) {
                base.setRedstonePowered(false);
            }
        }
    }

    protected boolean tryUseItemOnTank(Player player, InteractionHand hand, FluidTank tank) {
        ItemStack heldItem = player.m_21120_(hand);
        return StackUtil.isValid(heldItem) && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank);
    }

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        this.updateRedstoneState(worldIn, pos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tile;
        if (stack.m_41782_() && (tile = world.m_7702_(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            CompoundTag compound = stack.m_41784_().m_128469_("Data");
            base.readSyncableNBT(compound, TileEntityBase.NBTType.SAVE_BLOCK);
        }
    }

    public void m_5707_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, Player player) {
        BlockEntity tile;
        super.m_5707_(world, pos, state, player);
        if (!player.m_7500_() && (tile = world.m_7702_(pos)) instanceof TileEntityBase && ((TileEntityBase)tile).stopFromDropping) {
            player.m_5661_((Component)Component.m_237115_((String)"info.actuallyadditions.machineBroke").m_130940_(ChatFormatting.RED), false);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEntityBase) {
            return ((TileEntityBase)tile).getComparatorStrength();
        }
        return 0;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && this.shouldDropInventory(world, pos)) {
            this.dropInventory(world, pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean shouldDropInventory(Level world, BlockPos pos) {
        return true;
    }
}

