/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityShockSuppressor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockShockSuppressor
extends Block
implements EntityBlock {
    public BlockShockSuppressor() {
        super(ActuallyBlocks.defaultPickProps(20.0f, 2000.0f));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        Level world = event.getLevel();
        if (!world.f_46443_) {
            List affectedBlocks = event.getAffectedBlocks();
            List affectedEntities = event.getAffectedEntities();
            int rangeSq = 25;
            int use = 300;
            block0: for (TileEntityShockSuppressor suppressor : TileEntityShockSuppressor.SUPPRESSORS) {
                if (suppressor.isRedstonePowered) continue;
                BlockPos supPos = suppressor.m_58899_();
                ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
                ArrayList<BlockPos> posesToRemove = new ArrayList<BlockPos>();
                for (BlockPos pos : affectedBlocks) {
                    if (!(pos.m_123331_((Vec3i)supPos) <= (double)rangeSq)) continue;
                    posesToRemove.add(pos);
                }
                for (Entity entity : affectedEntities) {
                    if (!(entity.m_20182_().m_82531_((double)supPos.m_123341_(), (double)supPos.m_123342_(), (double)supPos.m_123343_()) <= (double)rangeSq)) continue;
                    entitiesToRemove.add(entity);
                }
                Collections.shuffle(entitiesToRemove);
                Collections.shuffle(posesToRemove);
                for (BlockPos pos : posesToRemove) {
                    if (suppressor.storage.getEnergyStored() < use) break;
                    suppressor.storage.extractEnergyInternal(use, false);
                    affectedBlocks.remove(pos);
                }
                for (Entity entity : entitiesToRemove) {
                    if (suppressor.storage.getEnergyStored() < use) continue block0;
                    suppressor.storage.extractEnergyInternal(use, false);
                    affectedEntities.remove(entity);
                }
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityShockSuppressor(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.f_46443_ ? TileEntityShockSuppressor::clientTick : TileEntityShockSuppressor::serverTick;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VoxelShapes.SUPPRESSOR_SHAPE;
    }
}

