/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomRedstoneface;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class BlockPhantom
extends BlockContainerBase
implements IHudDisplay {
    public final Type type;

    public BlockPhantom(Type type) {
        super(ActuallyBlocks.defaultPickProps(4.5f, 10.0f));
        this.type = type;
    }

    public boolean m_7899_(BlockState state) {
        return this.type == Type.REDSTONEFACE;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.m_7702_(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesWeak[side.ordinal()];
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.m_7702_(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesStrong[side.ordinal()];
        }
        return 0;
    }

    @Override
    public boolean shouldDropInventory(Level world, BlockPos pos) {
        return this.type == Type.PLACER || this.type == Type.BREAKER;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        switch (this.type) {
            case PLACER: {
                return new TileEntityPhantomPlacer(pos, state);
            }
            case BREAKER: {
                return new TileEntityPhantomBreaker(pos, state);
            }
            case LIQUIFACE: {
                return new TileEntityPhantomLiquiface(pos, state);
            }
            case ENERGYFACE: {
                return new TileEntityPhantomEnergyface(pos, state);
            }
            case REDSTONEFACE: {
                return new TileEntityPhantomRedstoneface(pos, state);
            }
        }
        return new TileEntityPhantomItemface(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return switch (this.type) {
            case Type.PLACER, Type.BREAKER -> {
                if (level.f_46443_) {
                    yield TileEntityPhantomPlacer::clientTick;
                }
                yield TileEntityPhantomPlacer::serverTick;
            }
            case Type.LIQUIFACE -> {
                if (level.f_46443_) {
                    yield TileEntityPhantomLiquiface::clientTick;
                }
                yield TileEntityPhantomLiquiface::serverTick;
            }
            case Type.ENERGYFACE -> {
                if (level.f_46443_) {
                    yield TileEntityPhantomEnergyface::clientTick;
                }
                yield TileEntityPhantomEnergyface::serverTick;
            }
            case Type.REDSTONEFACE -> {
                if (level.f_46443_) {
                    yield TileEntityPhantomRedstoneface::clientTick;
                }
                yield TileEntityPhantomRedstoneface::serverTick;
            }
            default -> level.f_46443_ ? TileEntityPhantomItemface::clientTick : TileEntityPhantomItemface::serverTick;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile;
        if (this.tryToggleRedstone(world, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)tile;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuProvider, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult)) {
            return;
        }
        BlockPos pos = ((BlockHitResult)rayCast).m_82425_();
        BlockEntity tile = minecraft.f_91073_.m_7702_(pos);
        if (tile != null && tile instanceof IPhantomTile) {
            IPhantomTile phantom = (IPhantomTile)tile;
            guiGraphics.m_280430_(minecraft.f_91062_, (Component)Component.m_237115_((String)"tooltip.actuallyadditions.blockPhantomRange.desc").m_130946_(": " + phantom.getRange()).m_130940_(ChatFormatting.GOLD), resolution.m_85445_() / 2 + 5, resolution.m_85446_() / 2 - 40, ChatFormatting.WHITE.m_126665_().intValue());
            if (phantom.hasBoundPosition()) {
                int distance = Mth.m_14165_((double)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82554_(new Vec3((double)phantom.getBoundPosition().m_123341_(), (double)phantom.getBoundPosition().m_123342_(), (double)phantom.getBoundPosition().m_123343_())));
                BlockState state = minecraft.f_91073_.m_8055_(phantom.getBoundPosition());
                Block block = state.m_60734_();
                Item item = Item.m_41439_((Block)block);
                String name = item.m_7626_(new ItemStack((ItemLike)block)).getString();
                BlockPhantom.drawWordWrap(guiGraphics, minecraft.f_91062_, (FormattedText)Component.m_237110_((String)"tooltip.actuallyadditions.phantom.blockInfo.desc", (Object[])new Object[]{name, phantom.getBoundPosition().m_123341_(), phantom.getBoundPosition().m_123342_(), phantom.getBoundPosition().m_123343_(), distance}), resolution.m_85445_() / 2 + 5, resolution.m_85446_() / 2 - 30, 200, 0xFFFFFF, true);
                if (phantom.isBoundThingInRange()) {
                    BlockPhantom.drawWordWrap(guiGraphics, minecraft.f_91062_, (FormattedText)Component.m_237115_((String)"tooltip.actuallyadditions.phantom.connectedRange.desc"), resolution.m_85445_() / 2 + 5, resolution.m_85446_() / 2 + 25, 200, 0xFFFFFF, true);
                } else {
                    BlockPhantom.drawWordWrap(guiGraphics, minecraft.f_91062_, (FormattedText)Component.m_237115_((String)"tooltip.actuallyadditions.phantom.connectedNoRange.desc"), resolution.m_85445_() / 2 + 5, resolution.m_85446_() / 2 + 25, 200, 0xFFFFFF, true);
                }
            } else {
                guiGraphics.m_280430_(minecraft.f_91062_, (Component)Component.m_237115_((String)"tooltip.actuallyadditions.phantom.notConnected.desc").m_130940_(ChatFormatting.RED), resolution.m_85445_() / 2 + 5, resolution.m_85446_() / 2 + 25, ChatFormatting.WHITE.m_126665_().intValue());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawWordWrap(GuiGraphics gg, Font font, FormattedText text, int x, int y, int width, int color, boolean shadow) {
        for (FormattedCharSequence line : font.m_92923_(text, width)) {
            gg.m_280649_(font, line, x, y, color, shadow);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static enum Type {
        ITEMFACE,
        PLACER,
        BREAKER,
        LIQUIFACE,
        ENERGYFACE,
        REDSTONEFACE;

    }
}

