/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockColoredLamp;
import de.ellpeck.actuallyadditions.mod.blocks.base.FullyDirectionalBlock;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockLampController
extends FullyDirectionalBlock {
    public BlockLampController() {
        super(ActuallyBlocks.defaultPickProps());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateLamp(worldIn, pos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateLamp(world, pos);
    }

    private void updateLamp(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            BlockState state = world.m_8055_(pos);
            BlockPos coords = pos.m_121945_(WorldUtil.getDirectionByPistonRotation(state));
            this.updateLampsAtPos(world, coords, world.m_277086_(pos) > 0, new ArrayList<BlockPos>());
        }
    }

    private void updateLampsAtPos(Level world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BlockColoredLamp) {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && !powered) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
            }
            if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && powered) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
            }
            this.updateSurrounding(world, pos, powered, updatedAlready);
        }
    }

    private void updateSurrounding(Level world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        for (Direction side : Direction.values()) {
            BlockPos offset = pos.m_121945_(side);
            if (updatedAlready.contains(offset)) continue;
            updatedAlready.add(pos);
            this.updateLampsAtPos(world, offset, powered, updatedAlready);
        }
    }
}

