/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockDisplayStand
extends BlockContainerBase {
    private final boolean isEmpowerer;

    public BlockDisplayStand(boolean empowerer) {
        super(ActuallyBlocks.defaultPickProps());
        this.isEmpowerer = empowerer;
    }

    public boolean isEmpowerer() {
        return this.isEmpowerer;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.isEmpowerer ? new TileEntityEmpowerer(pos, state) : new TileEntityDisplayStand(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return this.isEmpowerer ? (level.f_46443_ ? TileEntityEmpowerer::clientTick : TileEntityEmpowerer::serverTick) : (level.f_46443_ ? TileEntityDisplayStand::clientTick : TileEntityDisplayStand::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!world.f_46443_) {
            TileEntityInventoryBase stand = (TileEntityInventoryBase)world.m_7702_(pos);
            if (stand != null) {
                ItemStack stackThere = stand.inv.getStackInSlot(0);
                if (!heldItem.m_41619_()) {
                    int maxTransfer;
                    if (stackThere.m_41619_() && (!this.isEmpowerer || TileEntityEmpowerer.isPossibleInput(heldItem))) {
                        ItemStack toPut = heldItem.m_41777_();
                        toPut.m_41764_(1);
                        stand.inv.setStackInSlot(0, toPut);
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        } else {
                            player.m_21011_(hand, true);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (ItemUtil.canBeStacked(heldItem, stackThere) && (maxTransfer = Math.min(stackThere.m_41613_(), heldItem.m_41741_() - heldItem.m_41613_())) > 0) {
                        if (!player.m_7500_()) {
                            player.m_21008_(hand, StackUtil.grow(heldItem, maxTransfer));
                        } else {
                            player.m_21011_(hand, true);
                        }
                        ItemStack newStackThere = stackThere.m_41777_();
                        newStackThere.m_41774_(maxTransfer);
                        stand.inv.setStackInSlot(0, newStackThere);
                        return InteractionResult.SUCCESS;
                    }
                } else if (!stackThere.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                    player.m_21008_(hand, stackThere.m_41777_());
                    stand.inv.setStackInSlot(0, ItemStack.f_41583_);
                    return InteractionResult.CONSUME;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VoxelShapes.SIMPLE_STAND_SHAPE;
    }
}

