/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockColoredLamp
extends BlockBase {
    private static final HashMap<DyeColor, Supplier<Block>> COLOR_TO_LAMP = new HashMap<DyeColor, Supplier<Block>>(){
        {
            this.put(DyeColor.WHITE, ActuallyBlocks.LAMP_WHITE);
            this.put(DyeColor.ORANGE, ActuallyBlocks.LAMP_ORANGE);
            this.put(DyeColor.MAGENTA, ActuallyBlocks.LAMP_MAGENTA);
            this.put(DyeColor.LIGHT_BLUE, ActuallyBlocks.LAMP_LIGHT_BLUE);
            this.put(DyeColor.YELLOW, ActuallyBlocks.LAMP_YELLOW);
            this.put(DyeColor.LIME, ActuallyBlocks.LAMP_LIME);
            this.put(DyeColor.PINK, ActuallyBlocks.LAMP_PINK);
            this.put(DyeColor.GRAY, ActuallyBlocks.LAMP_GRAY);
            this.put(DyeColor.LIGHT_GRAY, ActuallyBlocks.LAMP_LIGHT_GRAY);
            this.put(DyeColor.CYAN, ActuallyBlocks.LAMP_CYAN);
            this.put(DyeColor.PURPLE, ActuallyBlocks.LAMP_PURPLE);
            this.put(DyeColor.BLUE, ActuallyBlocks.LAMP_BLUE);
            this.put(DyeColor.BROWN, ActuallyBlocks.LAMP_BROWN);
            this.put(DyeColor.GREEN, ActuallyBlocks.LAMP_GREEN);
            this.put(DyeColor.RED, ActuallyBlocks.LAMP_RED);
            this.put(DyeColor.BLACK, ActuallyBlocks.LAMP_BLACK);
        }
    };
    private static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public BlockColoredLamp() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_280658_(NoteBlockInstrument.HAT).m_60913_(0.5f, 3.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && stack.m_41619_()) {
            world.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LIT) == false)), 4);
            return InteractionResult.PASS;
        }
        if (!stack.m_41619_() && stack.m_41720_() instanceof DyeItem) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null) {
                return InteractionResult.FAIL;
            }
            Block newColor = COLOR_TO_LAMP.get(color).get();
            if (!world.f_46443_) {
                world.m_7731_(pos, (BlockState)newColor.m_49966_().m_61124_((Property)LIT, (Comparable)((Boolean)state.m_61143_((Property)LIT))), 2);
                if (!player.m_7500_()) {
                    player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
                }
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }
}

