/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.mod.blocks.AABlockItem;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.FullyDirectionalBlock;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockAtomicReconstructor
extends FullyDirectionalBlock.Container
implements IHudDisplay {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final int NAME_FLAVOR_AMOUNTS_1 = 12;
    public static final int NAME_FLAVOR_AMOUNTS_2 = 14;

    public BlockAtomicReconstructor() {
        super(ActuallyBlocks.defaultPickProps(10.0f, 80.0f));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (this.tryToggleRedstone(world, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (!world.f_46443_) {
            TileEntityAtomicReconstructor reconstructor = (TileEntityAtomicReconstructor)world.m_7702_(pos);
            if (reconstructor != null) {
                if (!heldItem.m_41619_()) {
                    Item item = heldItem.m_41720_();
                    if (item instanceof ILensItem && reconstructor.inv.getStackInSlot(0).m_41619_()) {
                        ItemStack toPut = heldItem.m_41777_();
                        toPut.m_41764_(1);
                        reconstructor.inv.setStackInSlot(0, toPut);
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        }
                        return InteractionResult.CONSUME;
                    }
                } else {
                    ItemStack slot = reconstructor.inv.getStackInSlot(0);
                    if (!slot.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                        player.m_21008_(hand, slot.m_41777_());
                        reconstructor.inv.setStackInSlot(0, ItemStack.f_41583_);
                        return InteractionResult.CONSUME;
                    }
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityAtomicReconstructor(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.f_46443_ ? TileEntityAtomicReconstructor::clientTick : TileEntityAtomicReconstructor::serverTick;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult) || minecraft.f_91073_ == null) {
            return;
        }
        BlockEntity tile = minecraft.f_91073_.m_7702_(((BlockHitResult)rayCast).m_82425_());
        if (tile instanceof TileEntityAtomicReconstructor) {
            MutableComponent lens_name;
            ItemStack slot = ((TileEntityAtomicReconstructor)tile).inv.getStackInSlot(0);
            if (slot.m_41619_()) {
                lens_name = Component.m_237115_((String)"info.actuallyadditions.nolens");
            } else {
                lens_name = slot.m_41720_().m_7626_(slot);
                AssetUtil.renderStackToGui(slot, resolution.m_85445_() / 2 + 15, resolution.m_85446_() / 2 - 19, 1.0f);
            }
            guiGraphics.m_280488_(minecraft.f_91062_, lens_name.m_6879_().m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC).getString(), (int)((float)resolution.m_85445_() / 2.0f + 35.0f), (int)((float)resolution.m_85446_() / 2.0f - 15.0f), 0xFFFFFF);
        }
    }

    @Override
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity t = world.m_7702_(pos);
        int i = 0;
        if (t instanceof TileEntityAtomicReconstructor) {
            i = ((TileEntityAtomicReconstructor)t).getEnergy();
        }
        return Mth.m_14045_((int)(i / 20000), (int)0, (int)15);
    }

    public static class TheItemBlock
    extends AABlockItem {
        private long lastSysTime;
        private int toPick1;
        private int toPick2;
        private final Block block;

        public TheItemBlock(Block blockIn) {
            super(blockIn, ActuallyBlocks.defaultBlockItemProperties);
            this.block = blockIn;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(@Nonnull ItemStack pStack, @Nullable Level pLevel, @Nonnull List<Component> pTooltip, @Nonnull TooltipFlag pFlag) {
            super.m_7373_(pStack, pLevel, pTooltip, pFlag);
            long sysTime = System.currentTimeMillis();
            if (this.lastSysTime + 3000L < sysTime) {
                this.lastSysTime = sysTime;
                if (Minecraft.m_91087_().f_91073_ != null) {
                    RandomSource random = Minecraft.m_91087_().f_91073_.f_46441_;
                    this.toPick1 = random.m_188503_(12) + 1;
                    this.toPick2 = random.m_188503_(14) + 1;
                }
            }
            String base = this.block.m_7705_() + ".info.";
            pTooltip.add((Component)Component.m_237115_((String)(base + "1." + this.toPick1)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)(base + "2." + this.toPick2))).m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)));
            if (pStack.m_41782_() && pStack.m_41783_().m_128441_("BlockEntityTag")) {
                CompoundTag BET = pStack.m_41783_().m_128469_("BlockEntityTag");
                int energy = 0;
                if (BET.m_128441_("Energy")) {
                    energy = BET.m_128451_("Energy");
                }
                NumberFormat format = NumberFormat.getInstance();
                pTooltip.add((Component)Component.m_237110_((String)"misc.actuallyadditions.power_single", (Object[])new Object[]{format.format(energy)}).m_130940_(ChatFormatting.GRAY));
                if (BET.m_128441_("IsPulseMode")) {
                    pTooltip.add((Component)Component.m_237115_((String)"info.actuallyadditions.redstoneMode").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)(BET.m_128471_("IsPulseMode") ? "info.actuallyadditions.redstoneMode.pulse" : "info.actuallyadditions.redstoneMode.deactivation")).m_130938_($ -> $.m_131140_(ChatFormatting.RED))));
                }
            }
        }

        protected boolean m_7274_(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
            boolean ret = super.m_7274_(pPos, pLevel, pPlayer, pStack, pState);
            return ret;
        }
    }
}

