/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditionsClient;
import de.ellpeck.actuallyadditions.mod.ActuallyTabs;
import de.ellpeck.actuallyadditions.mod.ClientRegistryHandler;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.config.conditions.BoolConfigCondition;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.TargetNBTIngredient;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.entity.EntityWorm;
import de.ellpeck.actuallyadditions.mod.event.CommonEvents;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyVillages;
import de.ellpeck.actuallyadditions.mod.gen.modifier.BoolConfigFeatureBiomeModifier;
import de.ellpeck.actuallyadditions.mod.gen.village.ActuallyPOITypes;
import de.ellpeck.actuallyadditions.mod.gen.village.ActuallyVillagers;
import de.ellpeck.actuallyadditions.mod.gen.village.InitVillager;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.Worm;
import de.ellpeck.actuallyadditions.mod.lootmodifier.ActuallyLootModifiers;
import de.ellpeck.actuallyadditions.mod.misc.BannerHelper;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.MethodHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.particle.ActuallyParticles;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="actuallyadditions")
public class ActuallyAdditions {
    public static final String MODID = "actuallyadditions";
    @Deprecated
    public static final String NAME = "Actually Additions";
    @Deprecated
    public static final String VERSION = "@VERSION@";
    @Deprecated
    public static final String GUIFACTORY = "de.ellpeck.actuallyadditions.mod.config.GuiFactory";
    public static final String DEPS = "required:forge@[14.23.5.2836,);before:craftingtweaks;after:fastbench@[1.3.2,)";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"actuallyadditions");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"actuallyadditions");
    public static final RegistryObject<EntityType<EntityWorm>> ENTITY_WORM = ENTITIES.register("worm", () -> EntityType.Builder.m_20704_(EntityWorm::new, (MobCategory)MobCategory.MISC).m_20712_("actuallyadditions:worm"));
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"actuallyadditions");
    public static final Supplier<Codec<BoolConfigFeatureBiomeModifier>> BOOL_CONFIG_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("bool_config_feature_modifier", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(BoolConfigFeatureBiomeModifier::biomes), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(BoolConfigFeatureBiomeModifier::features), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(BoolConfigFeatureBiomeModifier::step), (App)Codec.STRING.fieldOf("boolConfig").forGetter(BoolConfigFeatureBiomeModifier::boolConfig)).apply((Applicative)builder, BoolConfigFeatureBiomeModifier::new)));
    public static boolean commonCapsLoaded;

    public ActuallyAdditions() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ActuallyBlocks.init(eventBus);
        ActuallyItems.init(eventBus);
        ActuallyTabs.init(eventBus);
        ActuallyRecipes.init(eventBus);
        AASounds.init(eventBus);
        ActuallyVillagers.init(eventBus);
        ActuallyPOITypes.init(eventBus);
        ActuallyLootModifiers.init(eventBus);
        BannerHelper.init(eventBus);
        ActuallyContainers.CONTAINERS.register(eventBus);
        ENTITIES.register(eventBus);
        BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        eventBus.addListener(this::onConfigReload);
        ActuallyParticles.init(eventBus);
        ActuallyTags.init();
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(InitVillager::setupTrades);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
        MinecraftForge.EVENT_BUS.register((Object)new DungeonLoot());
        MinecraftForge.EVENT_BUS.addListener(Worm::onHoe);
        MinecraftForge.EVENT_BUS.addListener(ActuallyVillages::modifyVillageStructures);
        InitFluids.init(eventBus);
        eventBus.addListener(this::setup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(ActuallyAdditionsClient::setup);
            eventBus.addListener(ActuallyAdditionsClient::setupMenus);
            eventBus.addListener(ActuallyAdditionsClient::setupSpecialRenders);
            eventBus.addListener(ActuallyAdditionsClient::registerParticleFactories);
            eventBus.register((Object)new ClientRegistryHandler());
        });
        IFarmerBehavior.initBehaviors();
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        event.enqueueWork(() -> CraftingHelper.register((IConditionSerializer)BoolConfigCondition.Serializer.INSTANCE));
        ActuallyAdditionsAPI.methodHandler = new MethodHandler();
        ActuallyAdditionsAPI.connectionHandler = new LaserRelayConnectionHandler();
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)TargetNBTIngredient.Serializer.NAME, (IIngredientSerializer)TargetNBTIngredient.SERIALIZER));
        commonCapsLoaded = false;
        new UpdateChecker();
    }

    private void onConfigReload(ModConfigEvent event) {
        Item item1 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)CommonConfig.Other.REDSTONECONFIGURATOR.get()));
        Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)CommonConfig.Other.RELAYCONFIGURATOR.get()));
        CommonConfig.Other.redstoneConfigureItem = item1 != null ? item1 : Items.f_41852_;
        CommonConfig.Other.relayConfigureItem = item2 != null ? item2 : Items.f_41852_;
    }

    public void serverStarted(ServerStartedEvent event) {
    }

    public void serverStopped(ServerStoppedEvent event) {
        WorldData.clear();
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.m_214293_((String)MODID, (String)path);
    }

    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist().isClient()) {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            if (connection == null) {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level == null) {
                    return ServerLifecycleHooks.getCurrentServer().m_129894_();
                }
                return level.m_7465_();
            }
            return connection.m_105141_();
        }
        return ServerLifecycleHooks.getCurrentServer().m_129894_();
    }
}

