/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.MiningLensRecipe;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import org.jetbrains.annotations.Nullable;

public class MiningLensGenerator
extends RecipeProvider {
    public MiningLensGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "Mining Lens " + super.m_6055_();
    }

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput output, FinishedRecipe finishedRecipe, JsonObject advancementJson) {
        return null;
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.buildMiningLens(consumer);
    }

    private ResourceLocation folderRecipe(String folder, String recipe) {
        return new ResourceLocation("actuallyadditions", folder + "/" + recipe);
    }

    private void buildStoneOre(Consumer<FinishedRecipe> consumer, int weight, ItemLike output) {
        this.buildTagOre(consumer, (TagKey<Item>)Tags.Items.STONE, "stone", weight, output);
    }

    private void buildNetherOre(Consumer<FinishedRecipe> consumer, int weight, ItemLike output) {
        this.buildTagOre(consumer, (TagKey<Item>)Tags.Items.NETHERRACK, "nether", weight, output);
    }

    private void buildDeepSlateOre(Consumer<FinishedRecipe> consumer, int weight, ItemLike output) {
        consumer.accept(new MiningLensRecipe.Result(this.folderRecipe("mininglens", "deepslate_" + MiningLensGenerator.m_176632_((ItemLike)output)), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151034_}), weight, output, null, MiningLensRecipe.OutputType.ITEM));
    }

    private void buildStoneOre(Consumer<FinishedRecipe> consumer, int weight, TagKey<Item> output) {
        this.buildTagOre(consumer, (TagKey<Item>)Tags.Items.STONE, "stone", weight, output);
    }

    private void buildNetherOre(Consumer<FinishedRecipe> consumer, int weight, TagKey<Item> output) {
        this.buildTagOre(consumer, (TagKey<Item>)Tags.Items.NETHERRACK, "nether", weight, output);
    }

    private void buildTagOre(Consumer<FinishedRecipe> consumer, TagKey<Item> tag, String prefix, int weight, ItemLike output) {
        consumer.accept(new MiningLensRecipe.Result(this.folderRecipe("mininglens", prefix + "_" + MiningLensGenerator.m_176632_((ItemLike)output)), Ingredient.m_204132_(tag), weight, output, null, MiningLensRecipe.OutputType.ITEM));
    }

    private void buildTagOre(Consumer<FinishedRecipe> consumer, TagKey<Item> tag, String prefix, int weight, TagKey<Item> output) {
        ResourceLocation id = this.folderRecipe("mininglens", prefix + "_" + output.f_203868_().m_135815_().replaceAll("/", "_"));
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(output.f_203868_()))).addRecipe((FinishedRecipe)new MiningLensRecipe.Result(id, Ingredient.m_204132_(tag), weight, null, output, MiningLensRecipe.OutputType.TAG)).build(consumer, id);
    }

    private TagKey<Item> oreTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Objects.requireNonNull(ResourceLocation.m_214293_((String)"forge", (String)("ores/" + name))));
    }

    private void buildMiningLens(Consumer<FinishedRecipe> consumer) {
        this.buildStoneOre(consumer, 5000, (ItemLike)Items.f_41835_);
        this.buildStoneOre(consumer, 5000, (ItemLike)Items.f_150965_);
        this.buildStoneOre(consumer, 3000, (ItemLike)Items.f_41834_);
        this.buildStoneOre(consumer, 500, (ItemLike)Items.f_41833_);
        this.buildNetherOre(consumer, 500, (ItemLike)Items.f_41836_);
        this.buildStoneOre(consumer, 50, (ItemLike)Items.f_42010_);
        this.buildStoneOre(consumer, 250, (ItemLike)Items.f_41853_);
        this.buildStoneOre(consumer, 200, (ItemLike)Items.f_41977_);
        this.buildStoneOre(consumer, 30, (ItemLike)Items.f_42107_);
        this.buildNetherOre(consumer, 3000, (ItemLike)Items.f_42154_);
        this.buildStoneOre(consumer, 3000, (ItemLike)ActuallyBlocks.BLACK_QUARTZ_ORE.getItem());
        this.buildNetherOre(consumer, 1, (ItemLike)Items.f_42792_);
        this.buildDeepSlateOre(consumer, 2000, (ItemLike)Items.f_150963_);
        this.buildDeepSlateOre(consumer, 3000, (ItemLike)Items.f_150964_);
        this.buildDeepSlateOre(consumer, 3000, (ItemLike)Items.f_150966_);
        this.buildDeepSlateOre(consumer, 500, (ItemLike)Items.f_150967_);
        this.buildDeepSlateOre(consumer, 50, (ItemLike)Items.f_150994_);
        this.buildDeepSlateOre(consumer, 250, (ItemLike)Items.f_150993_);
        this.buildDeepSlateOre(consumer, 200, (ItemLike)Items.f_150968_);
        this.buildDeepSlateOre(consumer, 30, (ItemLike)Items.f_150969_);
        this.buildStoneOre(consumer, 250, this.oreTag("aluminum"));
        this.buildNetherOre(consumer, 50, this.oreTag("cobalt"));
        this.buildStoneOre(consumer, 2000, this.oreTag("lead"));
        this.buildStoneOre(consumer, 2000, this.oreTag("nickel"));
        this.buildStoneOre(consumer, 1000, this.oreTag("silver"));
        this.buildStoneOre(consumer, 1000, this.oreTag("sulfur"));
        this.buildStoneOre(consumer, 2000, this.oreTag("tin"));
        this.buildStoneOre(consumer, 1200, this.oreTag("yellorite"));
        this.buildStoneOre(consumer, 1000, this.oreTag("zinc"));
        this.buildStoneOre(consumer, 500, this.oreTag("uranium"));
    }
}

