/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import com.google.common.collect.ImmutableSet;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(Dungeon::new, LootContextParamSets.f_81411_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
        map.forEach((name, table) -> table.m_79136_(validationtracker));
    }

    public static class Dungeon
    implements LootTableSubProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> pOutput) {
            pOutput.accept(DungeonLoot.ENGINEER_HOUSE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ActuallyBlocks.WOOD_CASING.getItem()).m_79707_(60).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)10.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ActuallyBlocks.IRON_CASING.getItem()).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ActuallyItems.BLACK_QUARTZ.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ActuallyItems.BATS_WING.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ActuallyItems.DRILL_CORE.get())).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(ActuallyTags.Items.CRYSTALS).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(ActuallyTags.Items.CRYSTALS).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))));
        }
    }

    public static class Blocks
    extends BlockLootSubProvider {
        protected Blocks() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            CopyNbtFunction.Builder copyEnergy = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Energy", "BlockEntityTag.Energy");
            CopyNbtFunction.Builder copyPulseMode = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("IsPulseMode", "BlockEntityTag.IsPulseMode");
            this.dropNBT(ActuallyBlocks.ATOMIC_RECONSTRUCTOR, $ -> $.m_79078_((LootItemFunction.Builder)copyEnergy).m_79078_((LootItemFunction.Builder)copyPulseMode));
            this.dropKeepEnergy(ActuallyBlocks.DISPLAY_STAND);
            this.dropKeepEnergy(ActuallyBlocks.COAL_GENERATOR);
            this.dropKeepEnergy(ActuallyBlocks.OIL_GENERATOR);
            this.dropKeepEnergy(ActuallyBlocks.CRUSHER);
            this.dropKeepEnergy(ActuallyBlocks.CRUSHER_DOUBLE);
            this.dropKeepEnergy(ActuallyBlocks.POWERED_FURNACE);
            this.m_245724_(ActuallyBlocks.BATTERY_BOX.get());
            this.m_245724_(ActuallyBlocks.ITEM_INTERFACE_HOPPING.get());
            this.m_245724_(ActuallyBlocks.FARMER.get());
            this.m_245724_(ActuallyBlocks.BIOREACTOR.get());
            this.m_245724_(ActuallyBlocks.EMPOWERER.get());
            this.m_245724_(ActuallyBlocks.TINY_TORCH.get());
            this.m_245724_(ActuallyBlocks.SHOCK_SUPPRESSOR.get());
            this.m_245724_(ActuallyBlocks.PLAYER_INTERFACE.get());
            this.m_245724_(ActuallyBlocks.ITEM_INTERFACE.get());
            this.m_245724_(ActuallyBlocks.FIREWORK_BOX.get());
            this.m_245724_(ActuallyBlocks.VERTICAL_DIGGER.get());
            this.m_245724_(ActuallyBlocks.ENERGIZER.get());
            this.m_245724_(ActuallyBlocks.ENERVATOR.get());
            this.m_245724_(ActuallyBlocks.LAVA_FACTORY_CONTROLLER.get());
            this.m_245724_(ActuallyBlocks.CANOLA_PRESS.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_ITEMFACE.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_PLACER.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_LIQUIFACE.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_ENERGYFACE.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_REDSTONEFACE.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_BREAKER.get());
            this.m_245724_(ActuallyBlocks.FERMENTING_BARREL.get());
            this.m_245724_(ActuallyBlocks.FEEDER.get());
            this.m_245724_(ActuallyBlocks.HEAT_COLLECTOR.get());
            this.m_245724_(ActuallyBlocks.GREENHOUSE_GLASS.get());
            this.m_245724_(ActuallyBlocks.BREAKER.get());
            this.m_245724_(ActuallyBlocks.PLACER.get());
            this.m_245724_(ActuallyBlocks.DROPPER.get());
            this.m_245724_(ActuallyBlocks.CRATE_SMALL.get());
            this.m_245724_(ActuallyBlocks.FLUID_PLACER.get());
            this.m_245724_(ActuallyBlocks.FLUID_COLLECTOR.get());
            this.m_245724_(ActuallyBlocks.COFFEE_MACHINE.get());
            this.m_245724_(ActuallyBlocks.PHANTOM_BOOSTER.get());
            this.m_245724_(ActuallyBlocks.RANGED_COLLECTOR.get());
            this.m_245724_(ActuallyBlocks.LONG_RANGE_BREAKER.get());
            this.m_245724_(ActuallyBlocks.LEAF_GENERATOR.get());
            this.m_245724_(ActuallyBlocks.XP_SOLIDIFIER.get());
            this.m_245724_(ActuallyBlocks.LASER_RELAY.get());
            this.m_245724_(ActuallyBlocks.LASER_RELAY_ADVANCED.get());
            this.m_245724_(ActuallyBlocks.LASER_RELAY_EXTREME.get());
            this.m_245724_(ActuallyBlocks.LASER_RELAY_FLUIDS.get());
            this.m_245724_(ActuallyBlocks.LASER_RELAY_ITEM.get());
            this.m_245724_(ActuallyBlocks.LASER_RELAY_ITEM_ADVANCED.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_GREEN_BLOCK.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_WHITE_BLOCK.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_GREEN_STAIRS.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_WHITE_STAIRS.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_GREEN_SLAB.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_WHITE_SLAB.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_GREEN_WALL.get());
            this.m_245724_(ActuallyBlocks.ETHETIC_WHITE_WALL.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ.get());
            this.m_245724_(ActuallyBlocks.SMOOTH_BLACK_QUARTZ.get());
            this.m_245724_(ActuallyBlocks.CHISELED_BLACK_QUARTZ.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_PILLAR.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_BRICK.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_WALL.get());
            this.m_245724_(ActuallyBlocks.SMOOTH_BLACK_QUARTZ_WALL.get());
            this.m_245724_(ActuallyBlocks.CHISELED_BLACK_QUARTZ_WALL.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_PILLAR_WALL.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_BRICK_WALL.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_STAIR.get());
            this.m_245724_(ActuallyBlocks.SMOOTH_BLACK_QUARTZ_STAIR.get());
            this.m_245724_(ActuallyBlocks.CHISELED_BLACK_QUARTZ_STAIR.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_PILLAR_STAIR.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_BRICK_STAIR.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_SLAB.get());
            this.m_245724_(ActuallyBlocks.SMOOTH_BLACK_QUARTZ_SLAB.get());
            this.m_245724_(ActuallyBlocks.CHISELED_BLACK_QUARTZ_SLAB.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_PILLAR_SLAB.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_BRICK_SLAB.get());
            this.m_245724_(ActuallyBlocks.LAMP_WHITE.get());
            this.m_245724_(ActuallyBlocks.LAMP_ORANGE.get());
            this.m_245724_(ActuallyBlocks.LAMP_MAGENTA.get());
            this.m_245724_(ActuallyBlocks.LAMP_LIGHT_BLUE.get());
            this.m_245724_(ActuallyBlocks.LAMP_YELLOW.get());
            this.m_245724_(ActuallyBlocks.LAMP_LIME.get());
            this.m_245724_(ActuallyBlocks.LAMP_PINK.get());
            this.m_245724_(ActuallyBlocks.LAMP_GRAY.get());
            this.m_245724_(ActuallyBlocks.LAMP_LIGHT_GRAY.get());
            this.m_245724_(ActuallyBlocks.LAMP_CYAN.get());
            this.m_245724_(ActuallyBlocks.LAMP_PURPLE.get());
            this.m_245724_(ActuallyBlocks.LAMP_BLUE.get());
            this.m_245724_(ActuallyBlocks.LAMP_BROWN.get());
            this.m_245724_(ActuallyBlocks.LAMP_GREEN.get());
            this.m_245724_(ActuallyBlocks.LAMP_RED.get());
            this.m_245724_(ActuallyBlocks.LAMP_BLACK.get());
            this.m_245724_(ActuallyBlocks.LAMP_CONTROLLER.get());
            this.m_245724_(ActuallyBlocks.ENDER_CASING.get());
            this.m_245724_(ActuallyBlocks.IRON_CASING.get());
            this.m_245724_(ActuallyBlocks.LAVA_FACTORY_CASING.get());
            this.m_245724_(ActuallyBlocks.WOOD_CASING.get());
            this.m_245724_(ActuallyBlocks.ENORI_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.RESTONIA_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.PALIS_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.DIAMATINE_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.VOID_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMERADIC_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMPOWERED_ENORI_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMPOWERED_RESTONIA_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMPOWERED_PALIS_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMPOWERED_DIAMATINE_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMPOWERED_VOID_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.EMPOWERED_EMERADIC_CRYSTAL.get());
            this.m_245724_(ActuallyBlocks.ENORI_CRYSTAL_CLUSTER.get());
            this.m_245724_(ActuallyBlocks.RESTONIA_CRYSTAL_CLUSTER.get());
            this.m_245724_(ActuallyBlocks.PALIS_CRYSTAL_CLUSTER.get());
            this.m_245724_(ActuallyBlocks.DIAMATINE_CRYSTAL_CLUSTER.get());
            this.m_245724_(ActuallyBlocks.VOID_CRYSTAL_CLUSTER.get());
            this.m_245724_(ActuallyBlocks.EMERADIC_CRYSTAL_CLUSTER.get());
            this.m_245724_(ActuallyBlocks.BLACK_QUARTZ_ORE.get());
            this.m_247577_(ActuallyBlocks.BLACK_QUARTZ_ORE.get(), this.m_246109_(ActuallyBlocks.BLACK_QUARTZ_ORE.getBlock(), (Item)ActuallyItems.BLACK_QUARTZ.get()));
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.CANOLA, (Supplier<? extends Item>)ActuallyItems.CANOLA, (Supplier<? extends Item>)ActuallyItems.CANOLA_SEEDS);
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.RICE, (Supplier<? extends Item>)ActuallyItems.RICE, (Supplier<? extends Item>)ActuallyItems.RICE_SEEDS);
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.FLAX, (Supplier<? extends Item>)((Supplier<Item>)() -> Items.f_42401_), (Supplier<? extends Item>)ActuallyItems.FLAX_SEEDS);
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.COFFEE, (Supplier<? extends Item>)ActuallyItems.COFFEE_BEANS, (Supplier<? extends Item>)ActuallyItems.COFFEE_BEANS);
        }

        private void addCrop(Supplier<? extends Block> block, Supplier<? extends Item> item, Supplier<? extends Item> seed) {
            this.m_247577_(block.get(), this.m_245238_(block.get(), item.get(), seed.get(), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))));
        }

        private void dropNBT(Supplier<? extends Block> blockSupplier, Consumer<LootPool.Builder> lootFunctionProvider) {
            LootPool.Builder lootpool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)blockSupplier.get())));
            lootFunctionProvider.accept(lootpool);
            this.m_247577_(blockSupplier.get(), LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get(), (ConditionUserBuilder)lootpool)));
        }

        private void dropKeepEnergy(Supplier<? extends Block> blockSupplier) {
            this.dropNBT(blockSupplier, $ -> $.m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Energy", "BlockEntityTag.Energy")));
        }

        protected Iterable<Block> getKnownBlocks() {
            ImmutableSet ignoreForNow = ImmutableSet.of((Object)InitFluids.CANOLA_OIL.getBlock(), (Object)InitFluids.REFINED_CANOLA_OIL.getBlock(), (Object)InitFluids.CRYSTALLIZED_OIL.getBlock(), (Object)InitFluids.EMPOWERED_OIL.getBlock());
            return ActuallyBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(arg_0 -> Blocks.lambda$getKnownBlocks$3((Set)ignoreForNow, arg_0)).collect(Collectors.toList());
        }

        private static /* synthetic */ boolean lambda$getKnownBlocks$3(Set ignoreForNow, Block e) {
            return !ignoreForNow.contains(e);
        }
    }
}

