/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import com.google.common.collect.ImmutableSet;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.fluids.FluidAA;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "actuallyadditions", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleTool((Supplier<? extends Item>)ActuallyItems.ITEM_BOOKLET);
        this.simpleTool((Supplier<? extends Item>)ActuallyItems.CRATE_KEEPER);
        ActuallyItems.SIMPLE_ITEMS.forEach(this::simpleItem);
        ActuallyItems.TOOLS.forEach(this::simpleTool);
        ImmutableSet ignoreList = ImmutableSet.of((Object)InitFluids.CANOLA_OIL.getBlock(), (Object)InitFluids.REFINED_CANOLA_OIL.getBlock(), (Object)InitFluids.CRYSTALLIZED_OIL.getBlock(), (Object)InitFluids.EMPOWERED_OIL.getBlock(), (Object)((Block)ActuallyBlocks.CANOLA.get()), (Object)((Block)ActuallyBlocks.RICE.get()), (Object[])new Block[]{(Block)ActuallyBlocks.FLAX.get(), (Block)ActuallyBlocks.COFFEE.get(), ActuallyBlocks.TINY_TORCH.get()});
        ActuallyBlocks.BLOCKS.getEntries().stream().filter(arg_0 -> ItemModelGenerator.lambda$registerModels$0((Set)ignoreList, arg_0)).forEach(this::registerBlockModel);
        this.generateBucket(InitFluids.CANOLA_OIL);
        this.generateBucket(InitFluids.REFINED_CANOLA_OIL);
        this.generateBucket(InitFluids.CRYSTALLIZED_OIL);
        this.generateBucket(InitFluids.EMPOWERED_OIL);
        String wormpath = ActuallyItems.WORM.getId().m_135815_();
        ((ItemModelBuilder)this.singleTexture(wormpath, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + wormpath))).override().predicate(new ResourceLocation("actuallyadditions", "snail"), 1.0f).model((ModelFile)this.singleTexture("snail", this.mcLoc("item/handheld"), "layer0", this.modLoc("item/snail"))).end();
        String torchPath = ForgeRegistries.ITEMS.getKey((Object)ActuallyBlocks.TINY_TORCH.getItem()).m_135815_();
        this.singleTexture(torchPath, this.mcLoc("item/generated"), "layer0", this.modLoc("block/" + torchPath));
    }

    private void generateBucket(FluidAA fluidSupplier) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)fluidSupplier.getBucket()).m_135815_(), "forge:item/bucket")).customLoader((builder, template) -> DynamicFluidContainerModelBuilder.begin((ModelBuilder)builder, (ExistingFileHelper)template).fluid(fluidSupplier.get()));
    }

    private void registerBlockModel(RegistryObject<Block> block) {
        Object path = block.getId().m_135815_();
        if (block.get() instanceof WallBlock) {
            String name = path;
            path = "block/" + ((String)path).replace("_wall", "_block");
            ((ItemModelBuilder)this.withExistingParent(name, new ResourceLocation("block/wall_inventory"))).texture("wall", this.modLoc((String)path));
            return;
        }
        ((ItemModelBuilder)this.getBuilder((String)path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + (String)path)));
    }

    private void simpleTool(Supplier<? extends Item> item) {
        String path = BuiltInRegistries.f_257033_.m_7981_((Object)item.get()).m_135815_();
        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
    }

    private void simpleItem(Supplier<? extends Item> item) {
        String path = ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_();
        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
    }

    private static /* synthetic */ boolean lambda$registerModels$0(Set ignoreList, RegistryObject b) {
        return !ignoreList.contains(b.get());
    }
}

