/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import com.google.gson.JsonObject;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.Crystals;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EmpoweringRecipeGenerator
extends RecipeProvider {
    public EmpoweringRecipeGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "Empowering " + super.m_6055_();
    }

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput output, FinishedRecipe finishedRecipe, JsonObject advancementJson) {
        return null;
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL.get(), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get(), 5000, 50, Crystals.REDSTONE.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_RED).addModifier((ItemLike)Items.f_42691_).addModifier((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addModifier((ItemLike)Items.f_42460_).save(consumer, "restonia");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_RESTONIA_CRYSTAL.get(), (ItemLike)ActuallyBlocks.RESTONIA_CRYSTAL.get(), 50000, 500, Crystals.REDSTONE.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_RED).addModifier((ItemLike)Items.f_42691_).addModifier((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addModifier((ItemLike)Items.f_42460_).save(consumer, "restonia_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_PALIS_CRYSTAL.get(), (ItemLike)ActuallyItems.PALIS_CRYSTAL.get(), 5000, 50, Crystals.LAPIS.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_CYAN).addModifier((ItemLike)Items.f_42695_).addModifier((ItemLike)Items.f_42695_).addModifier((ItemLike)Items.f_42695_).save(consumer, "palis");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_PALIS_CRYSTAL.get(), (ItemLike)ActuallyBlocks.PALIS_CRYSTAL.get(), 50000, 500, Crystals.LAPIS.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_CYAN).addModifier((ItemLike)Items.f_42695_).addModifier((ItemLike)Items.f_42695_).addModifier((ItemLike)Items.f_42695_).save(consumer, "palis_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get(), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get(), 5000, 50, Crystals.DIAMOND.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE).addModifier((ItemLike)Items.f_42461_).addModifier((ItemLike)Items.f_42461_).addModifier((ItemLike)Items.f_41983_).save(consumer, "diamatine");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_DIAMATINE_CRYSTAL.get(), (ItemLike)ActuallyBlocks.DIAMATINE_CRYSTAL.get(), 50000, 500, Crystals.DIAMOND.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE).addModifier((ItemLike)Items.f_42461_).addModifier((ItemLike)Items.f_42461_).addModifier((ItemLike)Items.f_41983_).save(consumer, "diamatine_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get(), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get(), 5000, 50, Crystals.IRON.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_GRAY).addModifier((ItemLike)Items.f_42452_).addModifier((ItemLike)Items.f_42083_).addModifier((TagKey<Item>)Tags.Items.COBBLESTONE).save(consumer, "enori");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_ENORI_CRYSTAL.get(), (ItemLike)ActuallyBlocks.ENORI_CRYSTAL.get(), 50000, 500, Crystals.IRON.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_GRAY).addModifier((ItemLike)Items.f_42452_).addModifier((ItemLike)Items.f_42083_).addModifier((TagKey<Item>)Tags.Items.COBBLESTONE).save(consumer, "enori_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_VOID_CRYSTAL.get(), (ItemLike)ActuallyItems.VOID_CRYSTAL.get(), 5000, 50, Crystals.COAL.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_BLACK).addModifier((TagKey<Item>)ItemTags.f_13160_).addModifier((ItemLike)Items.f_42484_).addModifier((TagKey<Item>)Tags.Items.STONE).save(consumer, "void");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_VOID_CRYSTAL.get(), (ItemLike)ActuallyBlocks.VOID_CRYSTAL.get(), 50000, 500, Crystals.COAL.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_BLACK).addModifier((TagKey<Item>)ItemTags.f_13160_).addModifier((ItemLike)Items.f_42484_).addModifier((TagKey<Item>)Tags.Items.STONE).save(consumer, "void_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_EMERADIC_CRYSTAL.get(), (ItemLike)ActuallyItems.EMERADIC_CRYSTAL.get(), 5000, 50, Crystals.EMERALD.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIME).addModifier((ItemLike)Items.f_41864_).addModifier((TagKey<Item>)ItemTags.f_13180_).addModifier((TagKey<Item>)Tags.Items.SLIMEBALLS).save(consumer, "emeradic");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_EMERADIC_CRYSTAL.get(), (ItemLike)ActuallyBlocks.EMERADIC_CRYSTAL.get(), 50000, 500, Crystals.EMERALD.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIME).addModifier((ItemLike)Items.f_41864_).addModifier((TagKey<Item>)ItemTags.f_13180_).addModifier((TagKey<Item>)Tags.Items.SLIMEBALLS).save(consumer, "emeradic_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_CANOLA_SEED.get(), (ItemLike)ActuallyItems.CRYSTALLIZED_CANOLA_SEED.get(), 1000, 30, 16735052).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).save(consumer, "empowered_canola");
    }

    public static class EmpoweringBuilder {
        private final Item result;
        private final Ingredient base;
        private final int energy;
        private final int time;
        private final int color;
        private final List<Ingredient> modifiers = new ArrayList<Ingredient>();

        public EmpoweringBuilder(ItemLike resultIn, Ingredient baseIn, int energyIn, int timeIn, int colorIn) {
            this.result = resultIn.m_5456_();
            this.base = baseIn;
            this.energy = energyIn;
            this.time = timeIn;
            this.color = colorIn;
        }

        public static EmpoweringBuilder builder(ItemLike resultIn, ItemLike base, int energyIn, int timeIn, int colorIn) {
            return new EmpoweringBuilder(resultIn, Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), energyIn, timeIn, colorIn);
        }

        public EmpoweringBuilder addModifier(ItemLike input) {
            if (this.modifiers.size() >= 4) {
                throw new IllegalStateException("too many modifiers for empowering recipe, input: " + ForgeRegistries.ITEMS.getKey((Object)input.m_5456_()));
            }
            this.modifiers.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
            return this;
        }

        public EmpoweringBuilder addModifier(ItemStack input) {
            if (this.modifiers.size() >= 4) {
                throw new IllegalStateException("too many modifiers for empowering recipe, input: " + ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()));
            }
            this.modifiers.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}));
            return this;
        }

        public EmpoweringBuilder addModifier(TagKey<Item> input) {
            if (this.modifiers.size() >= 4) {
                throw new IllegalStateException("too many modifiers for empowering recipe, input: " + input.toString());
            }
            this.modifiers.add(Ingredient.m_204132_(input));
            return this;
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation name) {
            if (this.modifiers.size() != 4) {
                throw new IllegalStateException("invalid modifier count: " + this.modifiers.size() + ", recipe: " + name.toString());
            }
            consumer.accept(new EmpowererRecipe.Result(name, (ItemLike)this.result, this.base, this.modifiers.get(0), this.modifiers.get(1), this.modifiers.get(2), this.modifiers.get(3), this.energy, this.color, this.time));
        }

        public void save(Consumer<FinishedRecipe> consumer, String name) {
            ResourceLocation res = new ResourceLocation("actuallyadditions", "empowering/" + name);
            if (this.modifiers.size() != 4) {
                throw new IllegalStateException("invalid modifier count: " + this.modifiers.size() + ", recipe: " + res);
            }
            consumer.accept(new EmpowererRecipe.Result(res, (ItemLike)this.result, this.base, this.modifiers.get(0), this.modifiers.get(1), this.modifiers.get(2), this.modifiers.get(3), this.energy, this.color, this.time));
        }
    }
}

