/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.api;

import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.laser.ILaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.lens.LensConversion;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.api.recipe.WeightedOre;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.items.lens.LensColor;
import de.ellpeck.actuallyadditions.mod.items.lens.LensDeath;
import de.ellpeck.actuallyadditions.mod.items.lens.LensDetonation;
import de.ellpeck.actuallyadditions.mod.items.lens.LensDisenchanting;
import de.ellpeck.actuallyadditions.mod.items.lens.LensDisruption;
import de.ellpeck.actuallyadditions.mod.items.lens.LensKiller;
import de.ellpeck.actuallyadditions.mod.items.lens.LensMining;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class ActuallyAdditionsAPI {
    public static final String MOD_ID = "actuallyadditions";
    public static final String API_ID = "actuallyadditionsapi";
    public static final String API_VERSION = "34";
    public static final List<CrushingRecipe> CRUSHER_RECIPES = new ArrayList<CrushingRecipe>();
    public static final List<EmpowererRecipe> EMPOWERER_RECIPES = new ArrayList<EmpowererRecipe>();
    public static final List<IFarmerBehavior> FARMER_BEHAVIORS = new ArrayList<IFarmerBehavior>();
    public static final List<CoffeeIngredientRecipe> COFFEE_MACHINE_INGREDIENTS = new ArrayList<CoffeeIngredientRecipe>();
    public static final List<IBookletEntry> BOOKLET_ENTRIES = new ArrayList<IBookletEntry>();
    public static final List<IBookletChapter> ALL_CHAPTERS = new ArrayList<IBookletChapter>();
    public static final List<IBookletPage> BOOKLET_PAGES_WITH_ITEM_OR_FLUID_DATA = new ArrayList<IBookletPage>();
    @Deprecated
    public static final List<WeightedOre> STONE_ORES = new ArrayList<WeightedOre>();
    @Deprecated
    public static final List<WeightedOre> NETHERRACK_ORES = new ArrayList<WeightedOre>();
    public static IMethodHandler methodHandler;
    public static ILaserRelayConnectionHandler connectionHandler;
    public static IBookletEntry entryGettingStarted;
    public static IBookletEntry entryReconstruction;
    public static IBookletEntry entryLaserRelays;
    public static IBookletEntry entryFunctionalNonRF;
    public static IBookletEntry entryFunctionalRF;
    public static IBookletEntry entryGeneratingRF;
    public static IBookletEntry entryItemsNonRF;
    public static IBookletEntry entryItemsRF;
    public static IBookletEntry entryMisc;
    public static IBookletEntry entryUpdatesAndInfos;
    public static IBookletEntry entryAllAndSearch;
    public static IBookletEntry entryTrials;
    public static final LensConversion lensDefaultConversion;
    public static final Lens lensDetonation;
    public static final Lens lensDeath;
    public static final Lens lensEvenMoarDeath;
    public static final Lens lensColor;
    public static final Lens lensDisenchanting;
    public static final Lens lensMining;
    public static final Lens lensDisruption;

    public static void addMiningLensStoneOre(String oreName, int weight) {
        STONE_ORES.add(new WeightedOre(oreName, weight));
    }

    public static void addMiningLensNetherOre(String oreName, int weight) {
        NETHERRACK_ORES.add(new WeightedOre(oreName, weight));
    }

    public static void addCrusherRecipe(ResourceLocation id, ItemStack input, ItemStack outputOne, ItemStack outputTwo, int outputTwoChance) {
        CRUSHER_RECIPES.add(new CrushingRecipe(id, Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), outputOne, 1.0f, outputTwo.m_41619_() ? ItemStack.f_41583_ : outputTwo, outputTwoChance));
    }

    public static void addCrusherRecipe(ResourceLocation id, Ingredient input, ItemStack outputOne, ItemStack outputTwo, int outputTwoChance) {
        CRUSHER_RECIPES.add(new CrushingRecipe(id, input, outputOne, 1.0f, outputTwo.m_41619_() ? ItemStack.f_41583_ : outputTwo, outputTwoChance));
    }

    public static boolean addCrusherRecipes(List<ItemStack> inputs, List<ItemStack> outputOnes, int outputOneAmounts, List<ItemStack> outputTwos, int outputTwoAmounts, int outputTwoChance) {
        return methodHandler.addCrusherRecipes(inputs, outputOnes, outputOneAmounts, outputTwos, outputTwoAmounts, outputTwoChance);
    }

    @Deprecated
    public static boolean addCrusherRecipes(List<ItemStack> inputs, ItemStack outputOne, int outputOneAmount, ItemStack outputTwo, int outputTwoAmount, int outputTwoChance) {
        return methodHandler.addCrusherRecipes(inputs, outputOne, outputOneAmount, outputTwo, outputTwoAmount, outputTwoChance);
    }

    public static void addEmpowererRecipe(ResourceLocation id, Ingredient input, ItemStack output, Ingredient modifier1, Ingredient modifier2, Ingredient modifier3, Ingredient modifier4, int energyPerStand, int time, int particleColor) {
        EMPOWERER_RECIPES.add(new EmpowererRecipe(id, output, input, modifier1, modifier2, modifier3, modifier4, energyPerStand, time, particleColor));
    }

    @Deprecated
    public static void addReconstructorLensConversionRecipe(ItemStack input, ItemStack output, int energyUse, LensConversion type) {
    }

    @Deprecated
    public static void addReconstructorLensConversionRecipe(ItemStack input, ItemStack output, int energyUse) {
    }

    public static void addReconstructorLensConversionRecipe(Ingredient input, ItemStack output, int energyUse, LensConversion type) {
    }

    public static void addReconstructorLensConversionRecipe(Ingredient input, ItemStack output, int energyUse) {
    }

    public static void addCoffeeMachineIngredient(CoffeeIngredient ingredient) {
    }

    public static void addBookletEntry(IBookletEntry entry) {
        BOOKLET_ENTRIES.add(entry);
    }

    public static void addFarmerBehavior(IFarmerBehavior behavior) {
        FARMER_BEHAVIORS.add(behavior);
    }

    static {
        lensDefaultConversion = new LensConversion();
        lensDetonation = new LensDetonation();
        lensDeath = new LensDeath();
        lensEvenMoarDeath = new LensKiller();
        lensColor = new LensColor();
        lensDisenchanting = new LensDisenchanting();
        lensMining = new LensMining();
        lensDisruption = new LensDisruption();
    }
}

