/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.fastpaintings.DropMode;
import net.mehvahdjukaar.fastpaintings.FastPaintings;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintingBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    protected static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final IntegerProperty DOWN_OFFSET = IntegerProperty.m_61631_((String)"y_offset", (int)0, (int)5);
    protected static final IntegerProperty RIGHT_OFFSET = IntegerProperty.m_61631_((String)"x_offset", (int)0, (int)5);

    public PaintingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN_OFFSET, (Comparable)Integer.valueOf(0))).m_61124_((Property)RIGHT_OFFSET, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        DropMode mode = FastPaintings.SPECIAL_DROP.get();
        if (mode != DropMode.OFF && PaintingBlock.isMaster(state)) {
            PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42487_);
            if (m != null && (mode == DropMode.ALWAYS || m.isPlacedWithNbt())) {
                CompoundTag compoundTag = itemStack.m_41698_("EntityTag");
                Painting.m_269220_((CompoundTag)compoundTag, m.getVariant());
            }
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        if (FastPaintings.SPECIAL_DROP.get() != DropMode.OFF) {
            return List.of();
        }
        return super.m_49635_(state, params);
    }

    public boolean m_48673_(BlockState blockState) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        if (context instanceof EntityCollisionContext && !((ec = (EntityCollisionContext)context).m_193113_() instanceof HangingEntity)) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, DOWN_OFFSET, RIGHT_OFFSET});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public BlockState m_7417_(BlockState stateIn, Direction updateDir, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction dir = (Direction)stateIn.m_61143_((Property)FACING);
        if (updateDir.m_122424_() == dir && !facingState.m_280296_() && !DiodeBlock.m_52586_((BlockState)facingState)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, updateDir, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
        if (m != null) {
            pos = m.m_58899_();
            Direction dir = (Direction)state.m_61143_((Property)FACING);
            Holder<PaintingVariant> variant = m.getVariant();
            int width = PaintingBlock.getWidth(variant);
            int height = PaintingBlock.getHeight(variant);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    BlockPos p = pos.m_6625_(y).m_5484_(dir.m_122428_(), x);
                    BlockState b = level.m_8055_(p);
                    if (b.m_60713_((Block)this) && b.m_61143_((Property)FACING) == dir && (Integer)b.m_61143_((Property)DOWN_OFFSET) == y && (Integer)b.m_61143_((Property)RIGHT_OFFSET) == x) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            PaintingBlockEntity m = PaintingBlock.getMaster(state, pos, (BlockAndTintGetter)level);
            if (m != null) {
                pos = m.m_58899_();
                Direction dir = (Direction)state.m_61143_((Property)FACING);
                Holder<PaintingVariant> variant = m.getVariant();
                int width = PaintingBlock.getWidth(variant);
                int height = PaintingBlock.getHeight(variant);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        BlockPos p = pos.m_6625_(y).m_5484_(dir.m_122428_(), x);
                        if (!level.m_8055_(p).m_60713_((Block)this)) continue;
                        level.m_7471_(p, false);
                    }
                }
            } else {
                level.m_7471_(pos, false);
            }
        }
    }

    private static int getHeight(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.m_203334_()).m_218909_() / 16;
    }

    private static int getWidth(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.m_203334_()).m_218908_() / 16;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return PaintingBlock.isMaster(state) ? new PaintingBlockEntity(pos, state) : null;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return Items.f_42487_.m_7968_();
    }

    public static boolean tryConverting(Painting entity, @Nullable ItemStack stack) {
        BlockPos p;
        Level level = entity.m_9236_();
        Direction dir = entity.m_6350_();
        Holder variant = entity.m_28554_();
        int width = PaintingBlock.getWidth((Holder<PaintingVariant>)variant);
        int height = PaintingBlock.getHeight((Holder<PaintingVariant>)variant);
        if (width > 5 || height > 5) {
            return false;
        }
        AABB bb = entity.m_20191_();
        BlockPos pos = switch (dir) {
            default -> BlockPos.m_274561_((double)(bb.f_82291_ - 0.5), (double)(bb.f_82292_ - 0.5), (double)bb.f_82290_);
            case Direction.SOUTH -> BlockPos.m_274561_((double)bb.f_82288_, (double)(bb.f_82292_ - 0.5), (double)bb.f_82293_);
            case Direction.WEST -> BlockPos.m_274561_((double)bb.f_82288_, (double)(bb.f_82292_ - 0.5), (double)bb.f_82290_);
            case Direction.EAST -> BlockPos.m_274561_((double)bb.f_82291_, (double)(bb.f_82292_ - 0.5), (double)(bb.f_82293_ - 0.5));
        };
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                p = pos.m_6625_(y).m_5484_(dir.m_122428_(), x);
                if (level.m_8055_(p).m_60795_()) continue;
                return false;
            }
        }
        if (level.m_8055_(pos).m_60795_()) {
            BlockState state = (BlockState)FastPaintings.PAINTING_BLOCK.get().m_49966_().m_61124_((Property)FACING, (Comparable)dir);
            level.m_7731_(pos, state, 2);
            p = level.m_7702_(pos);
            if (p instanceof PaintingBlockEntity) {
                CompoundTag tag;
                Optional variant2;
                PaintingBlockEntity pe = (PaintingBlockEntity)p;
                pe.setVariant((Holder<PaintingVariant>)variant);
                if (stack != null && stack.m_41782_() && (variant2 = Painting.m_269030_((CompoundTag)(tag = stack.m_41737_("EntityTag")))).isPresent() && ((Holder)variant2.get()).m_203334_() == variant.m_203334_()) {
                    pe.setPlacedWithNbt(true);
                }
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (x == 0 && y == 0) continue;
                        BlockPos p2 = pos.m_6625_(y).m_5484_(dir.m_122428_(), x);
                        level.m_7731_(p2, (BlockState)((BlockState)state.m_61124_((Property)DOWN_OFFSET, (Comparable)Integer.valueOf(y))).m_61124_((Property)RIGHT_OFFSET, (Comparable)Integer.valueOf(x)), 2);
                    }
                }
                pe.requestModelReload();
                entity.m_146870_();
                return true;
            }
        }
        return false;
    }

    public static boolean isMaster(BlockState state) {
        return (Integer)state.m_61143_((Property)DOWN_OFFSET) == 0 && (Integer)state.m_61143_((Property)RIGHT_OFFSET) == 0;
    }

    public static PaintingBlockEntity getMaster(BlockState state, BlockPos pos, BlockAndTintGetter level) {
        Level l;
        BlockPos masterPos = PaintingBlock.getMasterPos(state, pos);
        if (level instanceof Level && !(l = (Level)level).m_46749_(pos)) {
            return null;
        }
        BlockEntity e = level.m_7702_(masterPos);
        if (e instanceof PaintingBlockEntity) {
            PaintingBlockEntity pe = (PaintingBlockEntity)e;
            return pe;
        }
        return null;
    }

    @NotNull
    private static BlockPos getMasterPos(BlockState state, BlockPos pos) {
        int y = (Integer)state.m_61143_((Property)DOWN_OFFSET);
        int x = (Integer)state.m_61143_((Property)RIGHT_OFFSET);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return pos.m_6630_(y).m_5484_(facing.m_122427_(), x);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction direction) {
        if (adjacentBlockState.m_60713_((Block)this) && adjacentBlockState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING)) {
            return true;
        }
        return state.m_61143_((Property)FACING) == direction || super.m_6104_(state, adjacentBlockState, direction);
    }
}

