/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.api.crafting;

import cech12.bucketlib.BucketLib;
import cech12.bucketlib.util.BucketLibUtil;
import cech12.bucketlib.util.RegistryUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class EntityIngredient
extends Ingredient {
    protected final EntityType<?> entityType;
    protected final TagKey<EntityType<?>> tag;
    private ItemStack[] matchingStacks;

    private EntityIngredient(EntityType<?> entityType, TagKey<EntityType<?>> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.entityType = entityType;
        this.tag = tag;
    }

    public EntityIngredient(EntityType<?> entityType) {
        this(entityType, null);
    }

    public EntityIngredient(TagKey<EntityType<?>> tag) {
        this(null, tag);
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ITag entityTypeIterator = this.entityType != null ? List.of(this.entityType) : Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).getTag(this.tag);
        for (EntityType entityType : entityTypeIterator) {
            RegistryUtil.BucketEntity bucketEntity = RegistryUtil.getBucketEntity(entityType);
            if (bucketEntity == null) continue;
            if (itemStack.m_41720_() == bucketEntity.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getEntityType(itemStack) == entityType;
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList entityTypes = new ArrayList();
            ITagManager entityTypeTags = ForgeRegistries.ENTITY_TYPES.tags();
            if (this.tag != null && entityTypeTags != null) {
                entityTypeTags.getTag(this.tag).forEach(entityTypes::add);
            } else if (this.entityType != null) {
                entityTypes.add(this.entityType);
            }
            List<RegistryUtil.BucketEntity> bucketEntities = RegistryUtil.getBucketEntities().stream().filter(bucketEntity -> entityTypes.contains(bucketEntity.entityType())).toList();
            for (RegistryUtil.BucketEntity bucketEntity2 : bucketEntities) {
                stacks.add(new ItemStack((ItemLike)bucketEntity2.bucketItem()));
            }
            for (RegistryUtil.BucketEntity bucketEntity2 : bucketEntities) {
                BucketLib.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldFluid(bucketEntity2.fluid()) && bucket.canHoldEntity(bucketEntity2.entityType())) {
                        ItemStack filledBucket = new ItemStack((ItemLike)bucket);
                        if (bucketEntity2.fluid() != Fluids.f_76191_) {
                            filledBucket = BucketLibUtil.addFluid(filledBucket, bucketEntity2.fluid());
                        }
                        filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity2.entityType());
                        stacks.add(filledBucket);
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", Serializer.NAME.toString());
        if (this.entityType != null) {
            jsonObject.addProperty("entity", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(this.entityType)).toString());
        }
        if (this.tag != null) {
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
        }
        return jsonObject;
    }

    public static final class Serializer
    implements IIngredientSerializer<EntityIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("bucketlib", "entity");

        private Serializer() {
        }

        @Nonnull
        public EntityIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            String entity = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new EntityIngredient(tag);
            }
            if (entity.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a entity ingredient with no entity or tag.");
            }
            return new EntityIngredient((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entity)));
        }

        @Nonnull
        public EntityIngredient parse(@Nonnull JsonObject json) {
            if (json.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(json.get("tag").getAsString());
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)tagId);
                return new EntityIngredient(tag);
            }
            ResourceLocation entity = new ResourceLocation(json.get("entity").getAsString());
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(entity)) {
                throw new JsonSyntaxException("Unknown entity type: " + String.valueOf(entity));
            }
            return new EntityIngredient((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entity));
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull EntityIngredient ingredient) {
            buffer.m_130070_(ingredient.entityType != null ? Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(ingredient.entityType)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    }
}

