/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Socket;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InsulatorBlockEntity
extends BlockEntity
implements Socket {
    public UUID id;
    public RadioRouter router;
    public float rotation = 0.0f;
    public Player connector;

    public InsulatorBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.INSULATOR, pos, state);
    }

    public void setConnector(Player connector) {
        this.connector = connector;
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SimpleRadioSounds.SPIN_INSULATOR, SoundSource.BLOCKS, 0.5f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
        }
    }

    public void removeConnector() {
        this.connector = null;
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SimpleRadioSounds.SPIN_INSULATOR, SoundSource.BLOCKS, 0.5f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (this.id == null && !level.f_46443_) {
            this.id = UUID.randomUUID();
        }
    }

    public void m_7651_() {
        if (this.router != null) {
            RadioManager.removeRouterSided(this.router, this.f_58857_.f_46443_);
        }
        super.m_7651_();
    }

    @Override
    public RadioRouter getRouter() {
        return this.router != null ? this.router : (this.m_58898_() ? RadioManager.getRouterSided(this.id, this.f_58857_.f_46443_) : null);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("uuid")) {
            this.id = tag.m_128342_("uuid");
        }
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.id != null) {
            tag.m_128362_("uuid", this.id);
        }
        super.m_183515_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InsulatorBlockEntity blockEntity) {
        if (blockEntity.router == null && blockEntity.id != null) {
            WorldlyPosition location = Services.COMPAT.modifyPosition(WorldlyPosition.of(pos, level, pos));
            blockEntity.router = SimpleRadioBlocks.INSULATOR.getOrCreateRouter(location, blockEntity.id, state);
        }
    }
}

