/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Routing;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.blocks.InsulatorBlockEntity;
import com.codinglitch.simpleradio.core.registry.entities.Wire;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InsulatorBlock
extends BaseEntityBlock
implements Routing {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty EMPTY = BooleanProperty.m_61465_((String)"empty");
    public static final BooleanProperty ROTATED = BooleanProperty.m_61465_((String)"rotated");
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)6.0, (double)1.0, (double)5.0, (double)10.0, (double)7.0, (double)11.0);
    private static final VoxelShape TOP_ROTATED_SHAPE = Block.m_49796_((double)5.0, (double)1.0, (double)6.0, (double)11.0, (double)7.0, (double)10.0);
    private static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)6.0, (double)9.0, (double)5.0, (double)10.0, (double)15.0, (double)11.0);
    private static final VoxelShape BOTTOM_ROTATED_SHAPE = Block.m_49796_((double)5.0, (double)9.0, (double)6.0, (double)11.0, (double)15.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)6.0, (double)5.0, (double)9.0, (double)10.0, (double)11.0, (double)15.0);
    private static final VoxelShape NORTH_ROTATED_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)9.0, (double)11.0, (double)10.0, (double)15.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)5.0, (double)1.0, (double)10.0, (double)11.0, (double)7.0);
    private static final VoxelShape SOUTH_ROTATED_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)1.0, (double)11.0, (double)10.0, (double)7.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)9.0, (double)5.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0);
    private static final VoxelShape WEST_ROTATED_SHAPE = Block.m_49796_((double)9.0, (double)6.0, (double)5.0, (double)15.0, (double)10.0, (double)11.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)1.0, (double)5.0, (double)6.0, (double)7.0, (double)11.0, (double)10.0);
    private static final VoxelShape EAST_ROTATED_SHAPE = Block.m_49796_((double)1.0, (double)6.0, (double)5.0, (double)7.0, (double)10.0, (double)11.0);

    public InsulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EMPTY, (Comparable)Boolean.valueOf(true)));
    }

    public static BlockPos travelExtension(BlockPos pos, LevelAccessor level) {
        for (Direction direction : Direction.values()) {
            InsulatorBlockEntity insulatorBlockEntity;
            List wires;
            BlockPos offsetPos = pos.m_121945_(direction);
            BlockEntity blockEntity = level.m_7702_(offsetPos);
            if (!(blockEntity instanceof InsulatorBlockEntity) || (wires = (insulatorBlockEntity = (InsulatorBlockEntity)blockEntity).getWires()).isEmpty()) continue;
            Wire wire = (Wire)wires.get(0);
            RadioRouter router = wire.transport(insulatorBlockEntity.getRouter());
            BlockPos routerPos = router.location.blockPos();
            BlockState blockState = level.m_8055_(routerPos);
            if (!(blockState.m_60734_() instanceof InsulatorBlock)) continue;
            Direction routerDirection = (Direction)blockState.m_61143_((Property)FACING);
            return routerPos.m_121945_(routerDirection.m_122424_());
        }
        return pos;
    }

    @Override
    public RadioRouter getOrCreateRouter(WorldlyPosition location, UUID id, BlockState state) {
        RadioRouter router = RadioManager.getRouterSided(id, location.isClientSide());
        if (router != null) {
            return router;
        }
        router = new RadioRouter(id);
        router.link = this.getClass();
        router.location = location;
        Vec3i normal = ((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122436_();
        router.connectionOffset = new Vec3((double)((float)normal.m_123341_() * 0.2f), (double)((float)normal.m_123342_() * 0.2f), (double)((float)normal.m_123343_() * 0.2f));
        router.allowDistribution();
        RadioManager.registerRouterSided(router, location.isClientSide(), null);
        return router;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder.m_61104_(new Property[]{FACING, ROTATED, EMPTY}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
        if (state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            Direction[] directions = context.m_6232_();
            Direction face = context.m_43719_();
            state = switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST -> {
                    for (Direction direction : directions) {
                        if (direction.m_122434_().test(face)) continue;
                        yield (BlockState)state.m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(direction.m_122434_().m_122479_()));
                    }
                    yield state;
                }
                case Direction.UP, Direction.DOWN -> {
                    for (Direction direction : directions) {
                        if (direction.m_122434_().m_122478_()) continue;
                        yield (BlockState)state.m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(direction == Direction.WEST || direction == Direction.EAST));
                    }
                    yield state;
                }
            };
            return state;
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122424_() == direction && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, level, pos, pos1);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean rotated = (Boolean)state.m_61143_((Property)ROTATED);
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> {
                if (rotated) {
                    yield TOP_ROTATED_SHAPE;
                }
                yield TOP_SHAPE;
            }
            case Direction.DOWN -> {
                if (rotated) {
                    yield BOTTOM_ROTATED_SHAPE;
                }
                yield BOTTOM_SHAPE;
            }
            case Direction.NORTH -> {
                if (rotated) {
                    yield NORTH_ROTATED_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            case Direction.SOUTH -> {
                if (rotated) {
                    yield SOUTH_ROTATED_SHAPE;
                }
                yield SOUTH_SHAPE;
            }
            case Direction.WEST -> {
                if (rotated) {
                    yield WEST_ROTATED_SHAPE;
                }
                yield WEST_SHAPE;
            }
            case Direction.EAST -> rotated ? EAST_ROTATED_SHAPE : EAST_SHAPE;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InsulatorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return InsulatorBlock.m_152132_(type, SimpleRadioBlockEntities.INSULATOR, InsulatorBlockEntity::tick);
    }
}

