/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.registry.screens;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.api.central.Frequencing;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.client.core.central.BaseButton;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRadioUpdatePacket;
import com.codinglitch.simpleradio.core.registry.menus.RadiosmitherMenu;
import com.codinglitch.simpleradio.platform.ClientServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RadiosmitherScreen
extends AbstractContainerScreen<RadiosmitherMenu>
implements ContainerListener {
    private static final ResourceLocation TEXTURE = CommonSimpleRadio.id("textures/gui/container/radiosmither.png");
    private static final Component AM = Component.m_237115_((String)"screen.simpleradio.radiosmither.am");
    private static final Component FM = Component.m_237115_((String)"screen.simpleradio.radiosmither.fm");
    private static final Component AM_DESCRIPTION = Component.m_237115_((String)"screen.simpleradio.radiosmither.am_description");
    private static final Component FM_DESCRIPTION = Component.m_237115_((String)"screen.simpleradio.radiosmither.fm_description");
    private static final int INCREMENT_THRESHOLD = 5;
    public ModulationButton FM_BUTTON;
    public ModulationButton AM_BUTTON;
    public KnobButton KNOB;
    public BaseButton APPLY_BUTTON;
    public EditBox FREQUENCY;
    protected String lastValidFrequency = Frequency.DEFAULT_FREQUENCY;
    public Frequency.Modulation modulation;
    protected int holdingFor = 0;
    protected int increment = 0;
    protected float time = 0.0f;

    public RadiosmitherScreen(RadiosmitherMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97727_ = 183;
        this.f_97729_ = 6;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private void updateFrequency(String input) {
        if (Frequency.check(input)) {
            this.lastValidFrequency = input;
        }
    }

    private void setModulation(Frequency.Modulation modulation) {
        this.modulation = modulation;
        if (modulation != null) {
            if (modulation == Frequency.Modulation.FREQUENCY) {
                this.FM_BUTTON.selected(true);
                this.AM_BUTTON.selected(false);
            } else if (modulation == Frequency.Modulation.AMPLITUDE) {
                this.AM_BUTTON.selected(true);
                this.FM_BUTTON.selected(false);
            }
        } else {
            this.FM_BUTTON.selected(false);
            this.AM_BUTTON.selected(false);
        }
    }

    protected void incrementFrequency() {
        this.incrementFrequency(1);
    }

    protected void incrementFrequency(int increment) {
        String freq = this.FREQUENCY.m_94155_();
        if (!freq.isEmpty()) {
            this.FREQUENCY.m_94144_(Frequency.incrementFrequency(freq, increment));
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        ItemStack tinkering = ((RadiosmitherMenu)this.f_97732_).getTinkering();
        if (tinkering != null && tinkering.m_41720_() instanceof Frequencing) {
            if (!this.FREQUENCY.m_93696_() && !Frequency.check(this.FREQUENCY.m_94155_())) {
                if (!Frequency.check(this.lastValidFrequency)) {
                    this.lastValidFrequency = Frequency.DEFAULT_FREQUENCY;
                }
                this.FREQUENCY.m_94144_(this.lastValidFrequency);
            }
        } else {
            this.FREQUENCY.m_94144_("");
        }
        if (this.f_96541_ != null) {
            int y = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
            if (this.KNOB.selected) {
                int centerY = this.KNOB.m_252907_() + this.KNOB.m_93694_() / 2;
                this.increment = (centerY - y) / 5;
            } else {
                this.increment = 0;
            }
            if (this.increment != 0) {
                ++this.holdingFor;
            }
            if (this.holdingFor > 5) {
                this.incrementFrequency(this.increment * (1 + Math.round((float)this.holdingFor / 5.0f)));
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
        if (this.modulation != null) {
            this.time = (this.time + delta * 0.1f) % 5.0f;
            int x = (int)(this.time / 5.0f * 142.0f);
            int iconX = 70;
            switch (this.modulation) {
                case AMPLITUDE: {
                    int iconY = 218;
                    graphics.m_280163_(TEXTURE, this.f_97735_ + 9, this.f_97736_ + 46, (float)(iconX + x), (float)iconY, 142 - x, 31, 256, 256);
                    graphics.m_280163_(TEXTURE, this.f_97735_ + 151 - x, this.f_97736_ + 46, (float)iconX, (float)iconY, x, 31, 256, 256);
                    break;
                }
                case FREQUENCY: {
                    int iconY = 184;
                    graphics.m_280163_(TEXTURE, this.f_97735_ + 9, this.f_97736_ + 45, (float)(iconX + x), (float)iconY, 142 - x, 34, 256, 256);
                    graphics.m_280163_(TEXTURE, this.f_97735_ + 151 - x, this.f_97736_ + 45, (float)iconX, (float)iconY, x, 34, 256, 256);
                }
            }
        }
        this.FREQUENCY.m_88315_(graphics, mouseX, mouseY, delta);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
    }

    public boolean m_6348_(double $$0, double $$1, int $$2) {
        if (this.KNOB.m_198029_()) {
            this.KNOB.onReleased();
        }
        if (this.APPLY_BUTTON.m_198029_()) {
            this.APPLY_BUTTON.selected = false;
            this.APPLY_BUTTON.m_93692_(false);
        }
        return super.m_6348_($$0, $$1, $$2);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.FREQUENCY = new EditBox(this.f_96547_, this.f_97735_ + 90, this.f_97736_ + 28, 50, 12, (Component)Component.m_237115_((String)"screen.simpleradio.radiosmither.frequency"));
        this.FREQUENCY.m_94202_(-1);
        this.FREQUENCY.m_94205_(-1);
        this.FREQUENCY.m_94190_(true);
        this.FREQUENCY.m_94182_(false);
        this.FREQUENCY.m_94199_(Frequency.FREQUENCY_DIGITS + 1);
        this.FREQUENCY.m_94151_(this::updateFrequency);
        this.FREQUENCY.m_94144_("");
        this.FREQUENCY.m_94153_(s -> s.isEmpty() || s.matches("^\\d[.\\d]*$"));
        this.lastValidFrequency = Frequency.DEFAULT_FREQUENCY;
        this.m_7787_((GuiEventListener)this.FREQUENCY);
        this.FREQUENCY.m_94186_(((RadiosmitherMenu)this.f_97732_).m_38853_(0).m_6657_());
        this.AM_BUTTON = new ModulationButton(this.f_97735_ + 8, this.f_97736_ + 23, false, () -> {
            this.AM_BUTTON.selected(true);
            this.FM_BUTTON.selected(false);
            this.modulation = Frequency.Modulation.AMPLITUDE;
        });
        this.FM_BUTTON = new ModulationButton(this.f_97735_ + 46, this.f_97736_ + 23, true, () -> {
            this.FM_BUTTON.selected(true);
            this.AM_BUTTON.selected(false);
            this.modulation = Frequency.Modulation.FREQUENCY;
        });
        this.KNOB = new KnobButton(this.f_97735_ + 154, this.f_97736_ + 44);
        this.APPLY_BUTTON = new BaseButton(this.f_97735_ + 153, this.f_97736_ + 24, 16, 16, 176, 0, TEXTURE, CommonComponents.f_237098_, () -> {
            this.APPLY_BUTTON.selected = true;
            if (this.FREQUENCY.m_94155_().isEmpty() || this.modulation == null) {
                return;
            }
            ClientServices.NETWORKING.sendToServer(new ServerboundRadioUpdatePacket(this.FREQUENCY.m_94155_(), this.modulation));
        });
        this.APPLY_BUTTON.hoverIconX = 208;
        this.APPLY_BUTTON.hoverIconY = 0;
        this.APPLY_BUTTON.selectedIconX = 192;
        this.APPLY_BUTTON.selectedIconY = 0;
        this.m_142416_((GuiEventListener)this.AM_BUTTON);
        this.m_142416_((GuiEventListener)this.FM_BUTTON);
        this.m_142416_((GuiEventListener)this.KNOB);
        this.m_142416_((GuiEventListener)this.APPLY_BUTTON);
        ((RadiosmitherMenu)this.f_97732_).m_38893_(this);
    }

    public void m_7861_() {
        super.m_7861_();
        ((RadiosmitherMenu)this.f_97732_).m_38943_(this);
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int slot, ItemStack stack) {
        if (slot == 0) {
            Item item;
            if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof Frequencing) {
                String numbers;
                Frequencing frequencing = (Frequencing)item;
                Frequency frequency = frequencing.getFrequency(stack);
                this.lastValidFrequency = numbers = frequency.frequency;
                this.FREQUENCY.m_94144_(numbers);
                this.FREQUENCY.m_94186_(true);
                this.m_7522_((GuiEventListener)this.FREQUENCY);
                this.setModulation(frequency.modulation);
            } else {
                this.FREQUENCY.m_94144_("");
                this.FREQUENCY.m_94186_(false);
                this.setModulation(null);
            }
        }
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int i1) {
    }

    public static class ModulationButton
    extends BaseButton {
        public ModulationButton(int x, int y, boolean isFM, Runnable onPress) {
            super(x, y, 35, 18, isFM ? 0 : 35, 184, TEXTURE, CommonComponents.f_237098_, onPress);
            this.selectedIconX = this.iconX;
            this.selectedIconY = 202;
            this.hoverIconX = this.iconX;
            this.hoverIconY = 220;
            this.m_257544_(Tooltip.m_257563_((Component)(isFM ? FM_DESCRIPTION : AM_DESCRIPTION), null));
        }

        public void selected(boolean selected) {
            this.selected = selected;
        }
    }

    public class KnobButton
    extends BaseButton {
        public KnobButton(int x, int y) {
            super(x, y, 16, 37, 176, 16, TEXTURE);
            this.hoverIconX = 208;
            this.hoverIconY = 16;
            this.selectedIconX = 192;
            this.selectedIconY = 16;
        }

        @Override
        public void blit(GuiGraphics graphics, int iconX, int iconY) {
            if (this.selected) {
                if (RadiosmitherScreen.this.increment != 0) {
                    if (RadiosmitherScreen.this.holdingFor % 2 == 0) {
                        super.blit(graphics, this.iconX, this.iconY);
                    } else {
                        super.blit(graphics, this.selectedIconX, this.selectedIconY);
                    }
                    return;
                }
                super.blit(graphics, this.iconX, this.iconY);
                return;
            }
            super.blit(graphics, iconX, iconY);
        }

        @Override
        public void m_5691_() {
            this.selected = true;
            RadiosmitherScreen.this.holdingFor = 0;
            if (RadiosmitherScreen.this.f_96541_ != null) {
                int y = (int)(((RadiosmitherScreen)RadiosmitherScreen.this).f_96541_.f_91067_.m_91594_() * (double)RadiosmitherScreen.this.f_96541_.m_91268_().m_85446_() / (double)RadiosmitherScreen.this.f_96541_.m_91268_().m_85444_());
                if ((double)y < (double)this.m_252907_() + (double)this.f_93619_ * 0.25) {
                    RadiosmitherScreen.this.incrementFrequency(1);
                } else if ((double)y > (double)this.m_252907_() + (double)this.f_93619_ * 0.75) {
                    RadiosmitherScreen.this.incrementFrequency(-1);
                }
            }
        }

        public void onReleased() {
            this.selected = false;
            this.m_93692_(false);
            RadiosmitherScreen.this.increment = 0;
            RadiosmitherScreen.this.holdingFor = 0;
        }
    }
}

