/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.simpleradio.api.central.Frequencing;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import java.util.UUID;
import net.minecraft.world.entity.Entity;

public interface Transmitting
extends Frequencing {
    default public RadioTransmitter startTransmitting(WorldlyPosition location, String frequencyName, Frequency.Modulation modulation, UUID id) {
        return this.startTransmitting(location, Frequency.getOrCreateFrequency(frequencyName, modulation), id);
    }

    default public RadioTransmitter startTransmitting(WorldlyPosition location, Frequency frequency, UUID id) {
        return frequency.tryAddTransmitter(id, location);
    }

    default public RadioTransmitter startTransmitting(WorldlyPosition location, Frequency frequency) {
        return this.startTransmitting(location, frequency, UUID.randomUUID());
    }

    default public RadioTransmitter startTransmitting(Entity entity, String frequencyName, Frequency.Modulation modulation, UUID id) {
        return this.startTransmitting(entity, Frequency.getOrCreateFrequency(frequencyName, modulation), id);
    }

    default public RadioTransmitter startTransmitting(Entity entity, Frequency frequency, UUID id) {
        return frequency.tryAddTransmitter(id, entity);
    }

    default public RadioTransmitter startTransmitting(Entity entity, Frequency frequency) {
        return this.startTransmitting(entity, frequency, UUID.randomUUID());
    }

    default public void stopTransmitting(String frequencyName, Frequency.Modulation modulation, UUID owner) {
        Frequency frequency = Frequency.getFrequency(frequencyName, modulation);
        if (frequency != null) {
            frequency.removeTransmitter(owner);
        }
    }

    default public void stopTransmitting() {
        Transmitting transmitting = this;
        if (transmitting instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity blockEntity = (AuditoryBlockEntity)((Object)transmitting);
            if (blockEntity.transmitter != null && blockEntity.transmitter.frequency != null) {
                this.stopTransmitting(blockEntity.transmitter.frequency.frequency, blockEntity.transmitter.frequency.modulation, blockEntity.id);
                blockEntity.transmitter.invalidate();
            }
        }
    }
}

