/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.simpleradio.api.central.Frequencing;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import java.util.UUID;
import net.minecraft.world.entity.Entity;

public interface Receiving
extends Frequencing {
    default public RadioReceiver startReceiving(WorldlyPosition location, String frequencyName, Frequency.Modulation modulation, UUID id) {
        return this.startReceiving(location, Frequency.getOrCreateFrequency(frequencyName, modulation), id);
    }

    default public RadioReceiver startReceiving(WorldlyPosition location, Frequency frequency) {
        return this.startReceiving(location, frequency, UUID.randomUUID());
    }

    default public RadioReceiver startReceiving(WorldlyPosition location, Frequency frequency, UUID id) {
        return frequency.tryAddReceiver(id, location);
    }

    default public RadioReceiver startReceiving(Entity entity, String frequencyName, Frequency.Modulation modulation, UUID id) {
        return this.startReceiving(entity, Frequency.getOrCreateFrequency(frequencyName, modulation), id);
    }

    default public RadioReceiver startReceiving(Entity entity, Frequency frequency) {
        return this.startReceiving(entity, frequency, UUID.randomUUID());
    }

    default public RadioReceiver startReceiving(Entity entity, Frequency frequency, UUID id) {
        return frequency.tryAddReceiver(id, entity);
    }

    default public void stopReceiving(String frequencyName, Frequency.Modulation modulation, UUID owner) {
        Frequency frequency = Frequency.getFrequency(frequencyName, modulation);
        if (frequency != null) {
            frequency.removeReceiver(owner);
        }
    }

    default public void stopReceiving() {
        Receiving receiving = this;
        if (receiving instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity blockEntity = (AuditoryBlockEntity)((Object)receiving);
            if (blockEntity.receiver != null && blockEntity.receiver.frequency != null) {
                this.stopReceiving(blockEntity.receiver.frequency.frequency, blockEntity.receiver.frequency.modulation, blockEntity.id);
                blockEntity.receiver.invalidate();
            }
        }
    }
}

