/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api;

import com.codinglitch.lexiconfig.classes.LexiconPageData;
import com.codinglitch.simpleradio.api.central.FrequencingType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class FrequencingRegistry {
    private static short id = 0;
    private static final HashMap<Short, FrequencingType> FREQUENCING_TYPES = new HashMap();

    public static FrequencingType get(ResourceLocation location) {
        return FREQUENCING_TYPES.values().stream().filter(type -> type.location.equals((Object)location)).findFirst().orElse(null);
    }

    public static FrequencingType getById(short id) {
        return FREQUENCING_TYPES.get(id);
    }

    public static FrequencingType fromConfig(LexiconPageData page) {
        FrequencingType newType = new FrequencingType();
        newType.page = page;
        newType.reload();
        return newType;
    }

    public static FrequencingType register(ResourceLocation location, FrequencingType frequencingType) {
        frequencingType.location = location;
        short s = id;
        id = (short)(s + 1);
        frequencingType.id = s;
        FREQUENCING_TYPES.put(frequencingType.id, frequencingType);
        return frequencingType;
    }

    public static void reload() {
        for (Map.Entry<Short, FrequencingType> entry : FREQUENCING_TYPES.entrySet()) {
            entry.getValue().reload();
        }
    }
}

