/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Locale;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moyai.Moyai;
import net.mehvahdjukaar.moyai.forge.MoyaiBlockImpl;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoyaiBlock
extends FallingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty BOTTOM = BlockStateProperties.f_61427_;
    public static final EnumProperty<RotationMode> MODE = EnumProperty.m_61587_((String)"mode", RotationMode.class);
    private static long LAST_GREETED_TIME = -24000L;
    @javax.annotation.Nullable
    private BlockPattern ironGolemBase;
    @javax.annotation.Nullable
    private BlockPattern ironGolemFull;

    protected MoyaiBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50137_).m_60977_().m_60913_(5.0f, 4.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)((Object)RotationMode.STATIC)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        level.m_186460_(currentPos, (Block)this, this.m_7198_());
        if (direction == Direction.UP) {
            boolean shouldBeBottom;
            boolean bl = shouldBeBottom = this.isMoyaiSameFacing(state, neighborState) && !this.isMoyaiSameFacing(state, level.m_8055_(currentPos.m_7495_()));
            if ((Boolean)state.m_61143_((Property)BOTTOM) != shouldBeBottom) {
                return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(shouldBeBottom));
            }
        } else if (direction == Direction.DOWN) {
            boolean shouldNotBeBottom = this.isMoyaiSameFacing(state, neighborState);
            if (shouldNotBeBottom) {
                if (((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
                    return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
                }
            } else if (this.isMoyaiSameFacing(state, level.m_8055_(currentPos.m_7494_()))) {
                return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true));
            }
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private boolean isMoyaiSameFacing(BlockState state, BlockState neighborState) {
        return neighborState.m_60713_((Block)this) && neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos pos;
        Level level = pContext.m_43725_();
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_(MODE, (Comparable)((Object)RotationMode.STATIC))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
        boolean bottom = this.isMoyaiSameFacing(state, level.m_8055_((pos = pContext.m_8083_()).m_7494_())) && !this.isMoyaiSameFacing(state, level.m_8055_(pos.m_7495_()));
        return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, MODE, BOTTOM});
    }

    public static boolean maybeEatSoap(ItemStack stack, BlockState state, BlockPos pos, Level level, @javax.annotation.Nullable Player player) {
        BlockPos facingPos;
        if (BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135815_().equals("soap") && Moyai.SUPP_INSTALLED && level.m_8055_(facingPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING))).m_60795_()) {
            if (player == null || player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (level.f_46443_ && player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"message.moyai.soap"), true);
            } else {
                level.m_46597_(facingPos, ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("supplementaries:bubble_block"))).m_49966_());
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        long time;
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (Utils.getID((Item)stack.m_41720_()).toString().equals("yippee:moyai_statue")) {
            if (pLevel.f_46443_) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"message.moyai.child"), true);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (MoyaiBlock.maybeEatSoap(stack, pState, pPos, pLevel, pPlayer)) {
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (pLevel.f_46443_ && Math.abs((time = pLevel.m_46468_()) - LAST_GREETED_TIME) >= 12000L) {
            LAST_GREETED_TIME = time;
            pPlayer.m_5661_((Component)Component.m_237115_((String)"message.moyai.angelo"), true);
            pPlayer.m_6674_(pHand);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (level instanceof WorldGenRegion) {
            if (!MoyaiBlock.isValidBiome((Holder<Biome>)level.m_204166_(pos))) {
                return false;
            }
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState s = level.m_8055_(pos.m_121945_(dir));
                if (dir == direction && !s.m_60795_()) {
                    return false;
                }
                if (!s.m_60713_((Block)this) || s.m_61143_((Property)FACING) != dir.m_122424_()) continue;
                return false;
            }
        }
        return true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isValidBiome(Holder<Biome> biome) {
        return MoyaiBlockImpl.isValidBiome(biome);
    }

    public int m_6248_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.m_284242_((BlockGetter)pReader, (BlockPos)pPos).f_283871_;
    }

    protected void m_6788_(FallingBlockEntity pFallingEntity) {
        pFallingEntity.m_149656_(2.0f, 40);
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState oldState, FallingBlockEntity blockEntity) {
        BlockState newState;
        if (!blockEntity.m_20067_()) {
            level.m_46796_(1045, pos, 0);
            this.trySpawnGolem(level, pos, false);
        }
        if ((newState = this.m_7417_(state, Direction.UP, level.m_8055_(pos.m_7494_()), (LevelAccessor)level, pos, pos.m_7494_())) != state) {
            level.m_46597_(pos, newState);
        }
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        pLevel.m_186460_(pPos, (Block)this, this.m_7198_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.trySpawnGolem(pLevel, pPos, true);
        }
    }

    public boolean canSpawnGolem(LevelReader pLevel, BlockPos pPos) {
        return this.getOrCreateIronGolemBase().m_61184_(pLevel, pPos) != null;
    }

    private boolean trySpawnGolem(Level pLevel, BlockPos pPos, boolean playerCreated) {
        BlockPattern pattern = this.getOrCreateIronGolemFull();
        BlockPattern.BlockPatternMatch patternMatch = pattern.m_61184_((LevelReader)pLevel, pPos);
        if (patternMatch != null) {
            for (int j = 0; j < pattern.m_61203_(); ++j) {
                for (int k = 0; k < pattern.m_61202_(); ++k) {
                    BlockInWorld matchBlock = patternMatch.m_61229_(j, k, 0);
                    pLevel.m_7731_(matchBlock.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    pLevel.m_46796_(2001, matchBlock.m_61176_(), Block.m_49956_((BlockState)matchBlock.m_61168_()));
                }
            }
            BlockPos blockpos = patternMatch.m_61229_(1, 2, 0).m_61176_();
            IronGolem irongolem = (IronGolem)EntityType.f_20460_.m_20615_(pLevel);
            irongolem.m_28887_(playerCreated);
            irongolem.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)this));
            irongolem.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            pLevel.m_7967_((Entity)irongolem);
            for (ServerPlayer player : pLevel.m_45976_(ServerPlayer.class, irongolem.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(player, (Entity)irongolem);
            }
            for (int i1 = 0; i1 < pattern.m_61203_(); ++i1) {
                for (int j1 = 0; j1 < pattern.m_61202_(); ++j1) {
                    BlockInWorld matchBlock = patternMatch.m_61229_(i1, j1, 0);
                    pLevel.m_6289_(matchBlock.m_61176_(), Blocks.f_50016_);
                }
            }
            return true;
        }
        return false;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', BlockInWorld.m_61169_(BlockBehaviour.BlockStateBase::m_60795_)).m_61249_();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(b -> b.m_60734_() == this)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', BlockInWorld.m_61169_(BlockBehaviour.BlockStateBase::m_60795_)).m_61249_();
        }
        return this.ironGolemFull;
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BOTTOM) == false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        long count;
        if (pState.m_61143_(MODE) == RotationMode.STATIC && pLevel.m_46462_()) {
            int i = pLevel.m_46941_();
            if (i == 0 || i == 4) {
                BlockState below = pLevel.m_8055_(pPos.m_7495_());
                Direction facing = (Direction)pState.m_61143_((Property)FACING);
                Direction dir = null;
                if (pLevel.f_46441_.m_188499_() && MoyaiBlock.canSee(pLevel, pPos, facing.m_122428_())) {
                    dir = facing.m_122428_();
                    this.rotateWithBelow(pState, pLevel, pPos, below, dir, RotationMode.ROTATING_LEFT);
                } else if (MoyaiBlock.canSee(pLevel, pPos, facing.m_122427_())) {
                    dir = facing.m_122427_();
                    this.rotateWithBelow(pState, pLevel, pPos, below, dir, RotationMode.ROTATING_RIGHT);
                }
                if (dir != null) {
                    pLevel.m_5594_(null, pPos, Moyai.MOYAI_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_186460_(pPos, (Block)this, 40 + pLevel.m_213780_().m_188503_(40));
                    MoyaiBlock.scarePlayers(pLevel, pPos, dir);
                }
            }
            return;
        }
        if ((double)pLevel.f_46441_.m_188501_() < 0.3 && (count = pLevel.m_8904_().m_27121_(p -> p.m_203656_(Moyai.MOYAI_POI_TAG), pPos, 10, PoiManager.Occupancy.ANY)) >= 5L) {
            pLevel.m_5594_(null, pPos, Moyai.MOYAI_THINK.get(), SoundSource.BLOCKS, 0.5f, 1.0f + pLevel.f_46441_.m_188501_() * 0.1f - pLevel.f_46441_.m_188501_() * 0.07f);
        }
    }

    private static void scarePlayers(ServerLevel pLevel, BlockPos pPos, Direction dir) {
        for (Player p : pLevel.m_45976_(Player.class, new AABB(pPos).m_82400_(5.0))) {
            Vec3 playerFacing;
            Vec3 facingMoyai;
            double dot;
            Vec3 eyePosition = p.m_146892_();
            BlockHitResult c = pLevel.m_45547_(new ClipContext(eyePosition, pPos.m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p));
            if (!c.m_82425_().equals((Object)pPos) || !((dot = (facingMoyai = new Vec3(dir.m_122424_().m_253071_())).m_82526_(playerFacing = p.m_20252_(0.0f).m_82541_())) > 0.6)) continue;
            p.m_6330_(Moyai.MOYAI_BOOM_SOUND.get(), SoundSource.BLOCKS, 0.05f, 1.0f);
        }
    }

    @NotNull
    private static boolean canSee(ServerLevel pLevel, BlockPos pos, Direction dir) {
        return !pLevel.m_8055_(pos.m_121945_(dir)).m_60796_((BlockGetter)pLevel, pos);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        BlockState above;
        RotationMode mode = (RotationMode)((Object)pState.m_61143_(MODE));
        boolean bottom = (Boolean)pState.m_61143_((Property)BOTTOM);
        if (mode != RotationMode.STATIC && !bottom) {
            BlockState below = pLevel.m_8055_(pPos.m_7495_());
            Direction dir = mode == RotationMode.ROTATING_RIGHT ? ((Direction)pState.m_61143_((Property)FACING)).m_122428_() : ((Direction)pState.m_61143_((Property)FACING)).m_122427_();
            this.rotateWithBelow(pState, pLevel, pPos, below, dir, RotationMode.STATIC);
            pLevel.m_5594_(null, pPos, Moyai.MOYAI_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
            MoyaiBlock.scarePlayers(pLevel, pPos, dir);
        }
        super.m_213897_(pState, pLevel, pPos, pRand);
        if (bottom && (above = pLevel.m_8055_(pPos.m_7494_())).m_60713_((Block)this)) {
            above.m_222963_(pLevel, pPos.m_7494_(), pRand);
        }
    }

    private void rotateWithBelow(BlockState pState, ServerLevel pLevel, BlockPos pPos, BlockState below, Direction dir, RotationMode mode) {
        pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_(MODE, (Comparable)((Object)mode))).m_61124_((Property)FACING, (Comparable)dir), 18);
        if (this.isMoyaiSameFacing(pState, below) && ((Boolean)below.m_61143_((Property)BOTTOM)).booleanValue()) {
            pLevel.m_7731_(pPos.m_7495_(), (BlockState)below.m_61124_((Property)FACING, (Comparable)dir), 18);
        }
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.2 + 1.0, (double)pPos.m_123343_() + 0.5, (double)pParam / 24.0, 0.0, 0.0);
            if (pLevel.f_46443_) {
                MoyaiBlock.setShaking(pPos, pParam);
            }
            return true;
        }
        return super.m_8133_(pState, pLevel, pPos, pId, pParam);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void setShaking(BlockPos pPos, int pParam) {
        void var1_1;
        MoyaiBlockImpl.setShaking(pPos, (int)var1_1);
    }

    public static enum RotationMode implements StringRepresentable
    {
        STATIC,
        ROTATING_LEFT,
        ROTATING_RIGHT;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

