/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moyai.MoyaiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class Moyai {
    public static final String MOD_ID = "moyai";
    public static final Supplier<SoundEvent> MOYAI_BOOM_SOUND = RegHelper.registerSound((ResourceLocation)Moyai.res("record.moyai_boom"));
    public static final Supplier<SoundEvent> MOYAI_ROTATE = RegHelper.registerSound((ResourceLocation)Moyai.res("block.moyai_rotate"));
    public static final Supplier<SoundEvent> MOYAI_THINK = RegHelper.registerSound((ResourceLocation)Moyai.res("block.moyai_think"));
    public static final Supplier<Block> MOYAI_BLOCK = RegHelper.registerBlock((ResourceLocation)Moyai.res("moyai"), MoyaiBlock::new);
    public static final Supplier<BlockItem> MOYAI_ITEM = RegHelper.registerItem((ResourceLocation)Moyai.res("moyai"), () -> new BlockItem(MOYAI_BLOCK.get(), new Item.Properties().m_41497_(Rarity.RARE)));
    public static final Supplier<PoiType> MOYAI_POI = RegHelper.register((ResourceLocation)Moyai.res("moyai"), () -> new PoiType((Set)ImmutableSet.builder().addAll((Iterable)MOYAI_BLOCK.get().m_49965_().m_61056_()).build(), 1, 1), (ResourceKey)Registries.f_256805_);
    public static final TagKey<PoiType> MOYAI_POI_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256805_, (ResourceLocation)Moyai.res("moyai"));
    public static final Supplier<GameEvent> MOYAI_BOOM_EVENT = RegHelper.register((ResourceLocation)Moyai.res("moyai_boom"), () -> new GameEvent("moyai_boom", 16), (ResourceKey)Registries.f_256827_);
    public static final boolean SUPP_INSTALLED = PlatHelper.isModLoaded((String)"supplementaries");

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        RegHelper.addItemsToTabsRegistration(Moyai::onAddItemToTabs);
        PlatHelper.addCommonSetup(Moyai::commonSetup);
    }

    private static void onAddItemToTabs(RegHelper.ItemToTabEvent event) {
        event.add(CreativeModeTabs.f_256791_, new ItemLike[]{(ItemLike)MOYAI_BLOCK.get()});
        event.add(CreativeModeTabs.f_256776_, new ItemLike[]{(ItemLike)MOYAI_BLOCK.get()});
    }

    public static void commonSetup() {
        Optional i = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("supplementaries:soap"));
        i.ifPresent(item -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                BlockState state = source.m_7727_().m_8055_(pos);
                if (state.m_60713_(MOYAI_BLOCK.get()) && MoyaiBlock.maybeEatSoap(stack, state, pos, (Level)source.m_7727_(), null)) {
                    return stack;
                }
                return super.m_7498_(source, stack);
            }
        }));
    }

    public static boolean onNotePlayed(LevelAccessor level, BlockPos pos, BlockState blockState) {
        BlockState below;
        if (blockState.m_61143_((Property)NoteBlock.f_55011_) == NoteBlockInstrument.BASEDRUM && (below = level.m_8055_(pos.m_7495_())).m_60734_() instanceof MoyaiBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_220407_(MOYAI_BOOM_EVENT.get(), pos, new GameEvent.Context(null, blockState));
            int i = (Integer)blockState.m_61143_((Property)NoteBlock.f_55013_);
            float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            level.m_5594_(null, pos, MOYAI_BOOM_SOUND.get(), SoundSource.RECORDS, 0.5f, f);
            serverLevel.m_7696_(pos.m_7495_(), below.m_60734_(), 0, i);
            return true;
        }
        return false;
    }
}

