/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.gson.GenericRegisteredSerializer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferPacket;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.util.JsonHelper;

public class FluidContainerTransferManager
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(FluidContainerTransferManager.class);
    public static final GenericRegisteredSerializer<IFluidContainerTransfer> TRANSFER_LOADERS = new GenericRegisteredSerializer();
    public static final String FOLDER = "mantle/fluid_transfer";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeHierarchyAdapter(IFluidContainerTransfer.class, TRANSFER_LOADERS).setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidContainerTransferManager INSTANCE = new FluidContainerTransferManager();
    private List<IFluidContainerTransfer> transfers = Collections.emptyList();
    @Nullable
    private Set<Item> containerItems = Collections.emptySet();
    private ICondition.IContext context = ICondition.IContext.EMPTY;

    private FluidContainerTransferManager() {
        super(GSON, FOLDER);
    }

    protected Set<Item> getContainerItems() {
        if (this.containerItems == null) {
            ArrayList builder = new ArrayList();
            Consumer<Item> consumer = builder::add;
            for (IFluidContainerTransfer transfer : this.transfers) {
                transfer.addRepresentativeItems(consumer);
            }
            this.containerItems = Set.copyOf(builder);
        }
        return this.containerItems;
    }

    public void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, e -> {
            e.addListener((PreparableReloadListener)this);
            this.context = e.getConditionContext();
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, OnDatapackSyncEvent.class, e -> JsonHelper.syncPackets(e, MantleNetwork.INSTANCE, new FluidContainerTransferPacket(this.getContainerItems())));
    }

    @Nullable
    private IFluidContainerTransfer loadFluidTransfer(ResourceLocation key, JsonObject json) {
        try {
            if (!json.has("conditions") || CraftingHelper.processConditions((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"conditions"), (ICondition.IContext)this.context)) {
                return (IFluidContainerTransfer)GSON.fromJson((JsonElement)json, IFluidContainerTransfer.class);
            }
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load fluid container transfer info from {}", (Object)key, (Object)e);
        }
        return null;
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager manager, ProfilerFiller profiler) {
        long time = System.nanoTime();
        this.transfers = splashList.entrySet().stream().map(entry -> this.loadFluidTransfer((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).toList();
        this.containerItems = null;
        log.info("Loaded {} dynamic modifiers in {} ms", (Object)this.transfers.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public boolean mayHaveTransfer(ItemStack stack) {
        return this.getContainerItems().contains(stack.m_41720_());
    }

    @Nullable
    public IFluidContainerTransfer getTransfer(ItemStack stack, FluidStack fluid) {
        for (IFluidContainerTransfer transfer : this.transfers) {
            if (!transfer.matches(stack, fluid)) continue;
            return transfer;
        }
        return null;
    }

    public void setContainerItems(@Nullable Set<Item> containerItems) {
        this.containerItems = containerItems;
    }
}

