/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SafeIngredientUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<IIngredientRenderer<?>> CRASHING_INGREDIENT_BATCH_RENDERERS = new HashSet();
    private static final Set<Object> CRASHING_INGREDIENT_RENDERERS = new HashSet<Object>();
    private static final Set<Object> CRASHING_INGREDIENT_TOOLTIPS = new HashSet<Object>();

    private SafeIngredientUtil() {
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        Minecraft minecraft = Minecraft.m_91087_();
        TooltipFlag.Default tooltipFlag = minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        tooltipFlag = tooltipFlag.m_257777_();
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, typedIngredient, tooltipFlag);
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, TooltipFlag.Default tooltipFlag) {
        T ingredient = typedIngredient.getIngredient();
        if (CRASHING_INGREDIENT_TOOLTIPS.contains(ingredient)) {
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
            return;
        }
        tooltip.setIngredient(typedIngredient);
        try {
            ingredientRenderer.getTooltip(tooltip, ingredient, (TooltipFlag)tooltipFlag);
            if (CRASHING_INGREDIENT_RENDERERS.contains(ingredient)) {
                SafeIngredientUtil.getRenderErrorTooltip(tooltip);
            }
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIPS.add(ingredient);
            ErrorUtil.logIngredientCrash(e, "Caught an error getting an Ingredient's tooltip", ingredientManager, typedIngredient.getType(), ingredient);
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
        }
    }

    public static <T> void renderTooltip(GuiGraphics guiGraphics, JeiTooltip tooltip, int x, int y, Font font, ItemStack itemStack, ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        T ingredient = typedIngredient.getIngredient();
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        if (CRASHING_INGREDIENT_TOOLTIPS.contains(ingredient)) {
            JeiTooltip errorTooltip = new JeiTooltip();
            SafeIngredientUtil.getTooltipErrorTooltip(errorTooltip);
            renderHelper.renderTooltip(guiGraphics, errorTooltip.getLines(), x, y, font, ItemStack.f_41583_);
            return;
        }
        try {
            renderHelper.renderTooltip(guiGraphics, tooltip.getLines(), x, y, font, itemStack);
        }
        catch (RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIPS.add(ingredient);
            CrashReportCategory category = new CrashReportCategory("tooltip");
            category.m_128159_("value", (Object)tooltip);
            ErrorUtil.logIngredientCrash(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient.getType(), ingredient, category);
        }
    }

    private static void getTooltipErrorTooltip(ITooltipBuilder tooltip) {
        MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.crash");
        tooltip.add((FormattedText)crash.m_130940_(ChatFormatting.RED));
    }

    private static void getRenderErrorTooltip(ITooltipBuilder tooltip) {
        MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.render.crash");
        tooltip.add((FormattedText)crash.m_130940_(ChatFormatting.RED));
    }

    public static <T> void renderBatch(GuiGraphics guiGraphics, IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer, List<BatchRenderElement<T>> elements) {
        if (CRASHING_INGREDIENT_BATCH_RENDERERS.contains(ingredientRenderer)) {
            for (BatchRenderElement<T> element : elements) {
                SafeIngredientUtil.render(guiGraphics, ingredientRenderer, ingredientType, element);
            }
            return;
        }
        try {
            ingredientRenderer.renderBatch(guiGraphics, elements);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_BATCH_RENDERERS.add(ingredientRenderer);
            LOGGER.error("Caught an error while rendering a batch of Ingredients with ingredient renderer: {}", ingredientRenderer.getClass(), (Object)e);
        }
    }

    public static <T> void render(GuiGraphics guiGraphics, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, int x, int y) {
        SafeIngredientUtil.render(guiGraphics, ingredientRenderer, typedIngredient.getType(), typedIngredient.getIngredient(), x, y);
    }

    public static <T> void render(GuiGraphics guiGraphics, IIngredientRenderer<T> ingredientRenderer, IIngredientType<T> ingredientType, BatchRenderElement<T> element) {
        SafeIngredientUtil.render(guiGraphics, ingredientRenderer, ingredientType, element.ingredient(), element.x(), element.y());
    }

    public static <T> void render(GuiGraphics guiGraphics, IIngredientRenderer<T> ingredientRenderer, IIngredientType<T> ingredientType, T ingredient, int x, int y) {
        if (CRASHING_INGREDIENT_RENDERERS.contains(ingredient)) {
            SafeIngredientUtil.renderError(guiGraphics);
            return;
        }
        try {
            ingredientRenderer.render(guiGraphics, ingredient, x, y);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDERERS.add(ingredient);
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                ErrorUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, ingredientType, ingredient);
                SafeIngredientUtil.renderError(guiGraphics);
            }
            CrashReport crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, ingredientType, ingredient);
            throw new ReportedException(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        guiGraphics.m_280056_(font, "ERR", 0, 0, -65536, false);
        guiGraphics.m_280056_(font, "OR", 0, 8, -65536, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

