/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.util.StringUtil;
import mezz.jei.core.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class DrawableWrappedText
implements IDrawable {
    private static final int lineSpacing = 2;
    private final List<FormattedText> descriptionLines;
    private final int lineHeight;
    private final int width;
    private final int height;

    public DrawableWrappedText(List<FormattedText> text, int maxWidth) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        Objects.requireNonNull(font);
        this.lineHeight = 9 + 2;
        Pair<List<FormattedText>, Boolean> result = StringUtil.splitLines(font, text, maxWidth, Integer.MAX_VALUE);
        this.descriptionLines = result.first();
        this.width = maxWidth;
        this.height = this.lineHeight * this.descriptionLines.size() - 2;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        Language language = Language.m_128107_();
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int yPos = 0;
        for (FormattedText descriptionLine : this.descriptionLines) {
            FormattedCharSequence charSequence = language.m_5536_(descriptionLine);
            guiGraphics.m_280649_(font, charSequence, xOffset, yPos + yOffset, -16777216, false);
            yPos += this.lineHeight;
        }
    }
}

