/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.oreCreeper.util;

import com.cozary.oreCreeper.util.ConfigurationHandler;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ExplosionTypes {
    public void oreExplosionEffect(Entity entity, Level entityWorld, double entityX, double entityY, double entityZ, OreType oreType) {
        double radius = 0.0;
        switch (oreType) {
            case COAL: {
                radius = (Double)ConfigurationHandler.SPAWN.coalCreeperExplosionRadius.get();
                break;
            }
            case COPPER: {
                radius = (Double)ConfigurationHandler.SPAWN.copperCreeperExplosionRadius.get();
                break;
            }
            case DIAMOND: {
                radius = (Double)ConfigurationHandler.SPAWN.diamondCreeperExplosionRadius.get();
                break;
            }
            case EMERALD: {
                radius = (Double)ConfigurationHandler.SPAWN.emeraldCreeperExplosionRadius.get();
                break;
            }
            case GOLD: {
                radius = (Double)ConfigurationHandler.SPAWN.goldCreeperExplosionRadius.get();
                break;
            }
            case IRON: {
                radius = (Double)ConfigurationHandler.SPAWN.ironCreeperExplosionRadius.get();
                break;
            }
            case LAPIS: {
                radius = (Double)ConfigurationHandler.SPAWN.lapisLazuliCreeperExplosionRadius.get();
                break;
            }
            case REDSTONE: {
                radius = (Double)ConfigurationHandler.SPAWN.redstoneCreeperExplosionRadius.get();
            }
        }
        if (entity instanceof PowerableMob) {
            radius = ((PowerableMob)entity).m_7090_() ? radius * 1.5 : radius;
        }
        entityWorld.m_254849_(entity, entityX, entityY, entityZ, 0.0f, Level.ExplosionInteraction.NONE);
        if (entityWorld.m_46469_().m_46207_(GameRules.f_46132_)) {
            int x = (int)(-radius);
            while ((double)x <= radius) {
                int y = (int)(-radius);
                while ((double)y <= radius) {
                    int z = (int)(-radius);
                    while ((double)z <= radius) {
                        BlockPos blockPos = new BlockPos((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        BlockState state = entityWorld.m_8055_(blockPos);
                        if (state != null && state.m_60734_() != null) {
                            Block stoneBlock = state.m_60734_();
                            Block[] baseBlockList = new Block[]{Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_49994_, Blocks.f_50129_, Blocks.f_152537_, Blocks.f_152550_, Blocks.f_152497_, Blocks.f_152496_};
                            if (stoneBlock != null && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius && Arrays.asList(baseBlockList).contains(stoneBlock)) {
                                if (stoneBlock.m_49966_() == Blocks.f_152550_.m_49966_()) {
                                    switch (new Random().nextInt(10) + 1) {
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            entityWorld.m_46597_(blockPos, stoneBlock.m_49966_());
                                            break;
                                        }
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: 
                                        case 8: 
                                        case 9: {
                                            entityWorld.m_46597_(blockPos, oreType.getDeepslateOreBlock().m_49966_());
                                            break;
                                        }
                                        case 10: {
                                            if (oreType.getRawBlock() == null) break;
                                            entityWorld.m_46597_(blockPos, oreType.getRawBlock().m_49966_());
                                        }
                                    }
                                } else {
                                    switch (new Random().nextInt(10) + 1) {
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            entityWorld.m_46597_(blockPos, stoneBlock.m_49966_());
                                            break;
                                        }
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: 
                                        case 8: 
                                        case 9: {
                                            entityWorld.m_46597_(blockPos, oreType.getOreBlock().m_49966_());
                                            break;
                                        }
                                        case 10: {
                                            if (oreType.getRawBlock() == null) break;
                                            entityWorld.m_46597_(blockPos, oreType.getRawBlock().m_49966_());
                                        }
                                    }
                                }
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public void netherExplosionEffect(Entity entity, Level entityWorld, double entityX, double entityY, double entityZ, OreType oreType) {
        double radius = 0.0;
        switch (oreType) {
            case NETHERGOLD: {
                radius = (Double)ConfigurationHandler.SPAWN.netherGoldCreeperExplosionRadius.get();
                break;
            }
            case NETHERQUARTZ: {
                radius = (Double)ConfigurationHandler.SPAWN.netherQuartzCreeperExplosionRadius.get();
            }
        }
        if (entity instanceof PowerableMob) {
            radius = ((PowerableMob)entity).m_7090_() ? radius * 1.5 : radius;
        }
        entityWorld.m_254849_(entity, entityX, entityY, entityZ, 0.0f, Level.ExplosionInteraction.NONE);
        if (entityWorld.m_46469_().m_46207_(GameRules.f_46132_)) {
            int x = (int)(-radius);
            while ((double)x <= radius) {
                int y = (int)(-radius);
                while ((double)y <= radius) {
                    int z = (int)(-radius);
                    while ((double)z <= radius) {
                        BlockPos blockPos = new BlockPos((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        BlockState state = entityWorld.m_8055_(blockPos);
                        if (state != null && state.m_60734_() != null) {
                            Block stoneBlock = state.m_60734_();
                            Block baseBlock = Blocks.f_50134_;
                            if (stoneBlock != null && baseBlock == stoneBlock && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                                switch (new Random().nextInt(10) + 1) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        entityWorld.m_46597_(blockPos, stoneBlock.m_49966_());
                                        break;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: {
                                        entityWorld.m_46597_(blockPos, oreType.getOreBlock().m_49966_());
                                    }
                                }
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public static enum OreType {
        COAL(Blocks.f_49997_, Blocks.f_50353_, Blocks.f_152469_),
        COPPER(Blocks.f_152505_, Blocks.f_152599_, Blocks.f_152506_),
        DIAMOND(Blocks.f_50089_, null, Blocks.f_152474_),
        EMERALD(Blocks.f_50264_, null, Blocks.f_152479_),
        GOLD(Blocks.f_49995_, Blocks.f_152600_, Blocks.f_152467_),
        IRON(Blocks.f_49996_, Blocks.f_152598_, Blocks.f_152468_),
        LAPIS(Blocks.f_50059_, null, Blocks.f_152472_),
        REDSTONE(Blocks.f_50173_, null, Blocks.f_152473_),
        NETHERGOLD(Blocks.f_49998_, Blocks.f_152600_, null),
        NETHERQUARTZ(Blocks.f_50331_, null, null);

        private final Block oreBlock;
        private final Block rawBlock;
        private final Block deepslateOreBlock;

        private OreType(Block oreBlock, Block rawBlock, Block deepslateOreBlock) {
            this.oreBlock = oreBlock;
            this.rawBlock = rawBlock;
            this.deepslateOreBlock = deepslateOreBlock;
        }

        public Block getOreBlock() {
            return this.oreBlock;
        }

        public Block getRawBlock() {
            return this.rawBlock;
        }

        public Block getDeepslateOreBlock() {
            return this.deepslateOreBlock;
        }
    }
}

