/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.oreCreeper.entities;

import com.cozary.oreCreeper.particles.ParticleList;
import com.cozary.oreCreeper.util.ConfigurationHandler;
import com.cozary.oreCreeper.util.ExplosionTypes;
import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class GoldCreeperEntity
extends Creeper {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(GoldCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(GoldCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(GoldCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public GoldCreeperEntity(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25);
    }

    public static boolean canOreCreeperSpawn(EntityType<? extends GoldCreeperEntity> creeper, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() < (Integer)ConfigurationHandler.SPAWN.goldCreeperMaxSpawnYLevel.get() && (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50069_) || world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_152550_)) && GoldCreeperEntity.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && GoldCreeperEntity.m_217057_(creeper, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoalCustom(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected boolean m_8028_() {
        return false;
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, @NotNull DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell = (int)((float)this.swell + p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            p_32304_.m_128379_("powered", true);
        }
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        p_32304_.m_128379_("ignited", this.m_32311_());
    }

    public void m_7378_(@NotNull CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)p_32296_.m_128471_("powered"));
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
        if (p_32296_.m_128471_("ignited")) {
            this.m_32312_();
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if ((i = this.m_32310_()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_32309_) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    protected void m_7472_(@NotNull DamageSource p_32292_, int p_32293_, boolean p_32294_) {
        GoldCreeperEntity creeper;
        super.m_7472_(p_32292_, p_32293_, p_32294_);
        Entity entity = p_32292_.m_7639_();
        if (entity != this && entity instanceof GoldCreeperEntity && (creeper = (GoldCreeperEntity)entity).m_32313_()) {
            creeper.m_32314_();
            this.m_19998_((ItemLike)Items.f_42682_);
        }
    }

    public boolean m_7327_(@NotNull Entity p_32281_) {
        return true;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float m_32320_(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int m_32310_() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void m_32283_(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(@NotNull ServerLevel p_32286_, @NotNull LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    @NotNull
    protected InteractionResult m_6071_(Player p_32301_, @NotNull InteractionHand p_32302_) {
        ItemStack itemstack = p_32301_.m_21120_(p_32302_);
        if (itemstack.m_150930_(Items.f_42409_)) {
            this.m_9236_().m_6263_(p_32301_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.m_32312_();
                itemstack.m_41622_(1, (LivingEntity)p_32301_, p_32290_ -> p_32290_.m_21190_(p_32302_));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_32301_, p_32302_);
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    public boolean m_32311_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void m_32312_() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public boolean m_32313_() {
        return this.m_7090_() && this.droppedSkulls < 1;
    }

    public void m_32314_() {
        ++this.droppedSkulls;
    }

    private void explodeCreeper() {
        double d0 = this.f_19796_.m_188583_() * 0.02;
        double d1 = this.f_19796_.m_188583_() * 0.02;
        double d2 = this.f_19796_.m_188583_() * 0.02;
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            new ExplosionTypes().oreExplosionEffect((Entity)this, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), ExplosionTypes.OreType.GOLD);
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)((SimpleParticleType)ParticleList.GOLD_EXPLOSION.get()), this.m_20185_() + 0.5, this.m_20186_(), this.m_20189_() + 0.5, 500, d1, d2, d0, 0.5);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    public static class SwellGoalCustom
    extends Goal {
        private final GoldCreeperEntity creeper;
        private LivingEntity target;

        public SwellGoalCustom(GoldCreeperEntity p_25919_) {
            this.creeper = p_25919_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.creeper.m_5448_();
            return this.creeper.m_32310_() > 0 || livingentity != null && this.creeper.m_20280_((Entity)livingentity) < 9.0;
        }

        public void m_8056_() {
            this.creeper.m_21573_().m_26573_();
            this.target = this.creeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.creeper.m_32283_(-1);
            } else if (this.creeper.m_20280_((Entity)this.target) > 49.0) {
                this.creeper.m_32283_(-1);
            } else if (!this.creeper.m_21574_().m_148306_((Entity)this.target)) {
                this.creeper.m_32283_(-1);
            } else {
                this.creeper.m_32283_(1);
            }
        }
    }
}

