/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.handler;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.ability.Ability;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.capability.FrenzyCapability;
import com.eeeab.eeeabsmobs.sever.capability.PlayerCapability;
import com.eeeab.eeeabsmobs.sever.capability.VertigoCapability;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobEntity;
import com.eeeab.eeeabsmobs.sever.entity.IBoss;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityAbsCorpse;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpseWarlock;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalExecutioner;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityBloodBall;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityShamanBomb;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.AttributeInit;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.item.IUnbreakableItem;
import com.eeeab.eeeabsmobs.sever.item.ItemDemolisher;
import com.eeeab.eeeabsmobs.sever.message.MessageFrenzyEffect;
import com.eeeab.eeeabsmobs.sever.message.MessageVertigoEffect;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public final class HandlerServerEvent {
    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("eeeabsmobs", "vertigo_processor"), (ICapabilityProvider)new VertigoCapability.VertigoCapabilityProvider());
            event.addCapability(new ResourceLocation("eeeabsmobs", "frenzy_processor"), (ICapabilityProvider)new FrenzyCapability.FrenzyCapabilityProvider());
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("eeeabsmobs", "ability_processor"), (ICapabilityProvider)new AbilityCapability.AbilityCapabilityProvider());
            event.addCapability(new ResourceLocation("eeeabsmobs", "player_processor"), (ICapabilityProvider)new PlayerCapability.PlayerCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onItemAttributeModifier(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item instanceof IUnbreakableItem) {
            IUnbreakableItem unbreakableItem = (IUnbreakableItem)item;
            ItemStack itemStack = event.getItemStack();
            CompoundTag tag = itemStack.m_41784_();
            boolean flag = tag.m_128441_("Unbreakable");
            if (!unbreakableItem.canBreakItem()) {
                if (!flag) {
                    tag.m_128379_("Unbreakable", true);
                    tag.m_128379_("CodeAddFlag", true);
                }
            } else if (flag && tag.m_128441_("CodeAddFlag")) {
                tag.m_128473_("Unbreakable");
                tag.m_128473_("CodeAddFlag");
            }
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        Raider raider;
        Zombie zombie;
        AbstractGolem abstractGolem;
        AbilityCapability.IAbilityCapability capability;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (capability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)entity)) != null) {
            capability.onInit((LivingEntity)entity);
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        if (entity instanceof AbstractGolem && !((abstractGolem = (AbstractGolem)entity) instanceof Shulker)) {
            abstractGolem.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractGolem, EntityAbsImmortal.class, 5, false, false, null));
            abstractGolem.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractGolem, EntityAbsCorpse.class, 5, false, false, null));
        }
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton abstractSkeleton = (AbstractSkeleton)entity;
            abstractSkeleton.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractSkeleton, EntityAbsImmortal.class, 0, true, false, null));
        }
        if (entity instanceof Zombie && !((zombie = (Zombie)entity) instanceof ZombifiedPiglin)) {
            zombie.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)zombie, EntityAbsImmortal.class, 0, true, false, null));
            zombie.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)zombie, EntityAbsCorpse.class, 0, true, false, null));
        }
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            villager.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)villager, EntityAbsImmortal.class, 6.0f, 1.0, 1.2));
            villager.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)villager, EntityAbsCorpse.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof Raider && !((raider = (Raider)entity) instanceof SpellcasterIllager)) {
            raider.f_21345_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)raider, EntityAbsImmortal.class, 5, true, false, null));
        }
    }

    @SubscribeEvent
    public void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null) {
            FrenzyCapability.IFrenzyCapability frenzyCapability;
            AbilityCapability.IAbilityCapability abilityCapability;
            LivingEntity entity = event.getEntity();
            VertigoCapability.IVertigoCapability vertigoCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (vertigoCapability != null) {
                vertigoCapability.tick(entity);
            }
            if ((abilityCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.CUSTOM_ABILITY_CAPABILITY)) != null) {
                abilityCapability.tick(entity);
            }
            if ((frenzyCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.FRENZY_EFFECT_CAPABILITY)) != null) {
                frenzyCapability.tick(entity);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        this.useGuardianCoreStack(event);
        PlayerCapability.IPlayerCapability playerCapability = HandlerCapability.getCapability((Entity)event.player, HandlerCapability.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            playerCapability.tick(event.player);
        }
    }

    private void useGuardianCoreStack(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Ability<?> ability = AbilityHandler.INSTANCE.getAbility(player, AbilityHandler.GUARDIAN_LASER_ABILITY_TYPE);
        ItemStack itemStack = player.m_21211_();
        if (ability != null) {
            if (!ability.isUsing()) {
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!stack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) continue;
                    stack.m_41721_(Math.max(stack.m_41773_() - 1, 0));
                }
                for (ItemStack stack : player.m_150109_().f_35976_) {
                    if (!stack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) continue;
                    stack.m_41721_(Math.max(stack.m_41773_() - 1, 0));
                }
            } else if (itemStack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) {
                if (itemStack.m_41773_() + 1 < itemStack.m_41776_()) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                } else {
                    ability.end();
                }
            } else {
                ability.end();
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCancelable() && entity instanceof EEEABMobEntity && entity.m_21223_() > 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAddPointEffect(MobEffectEvent.Added event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_()) {
            this.doCRCapabilityWithEffect(effectInstance, event.getEntity(), true);
        }
    }

    @SubscribeEvent
    public void onRemovePotionEffect(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_() && effectInstance != null) {
            this.doCRCapabilityWithEffect(effectInstance, event.getEntity(), false);
        }
    }

    @SubscribeEvent
    public void onExpirePotionEffect(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_() && effectInstance != null) {
            this.doCRCapabilityWithEffect(effectInstance, event.getEntity(), false);
        }
    }

    private void doCRCapabilityWithEffect(MobEffectInstance effectInstance, LivingEntity entity, boolean flag) {
        Object capability;
        if (effectInstance.m_19544_() == EffectInit.VERTIGO_EFFECT.get()) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageVertigoEffect(entity, flag));
            capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (capability != null) {
                if (flag) {
                    capability.onStart(entity);
                } else {
                    capability.onEnd(entity);
                }
            }
        }
        if (effectInstance.m_19544_() == EffectInit.FRENZY_EFFECT.get()) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageFrenzyEffect(entity, flag));
            capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.FRENZY_EFFECT_CAPABILITY);
            if (capability != null) {
                capability.setLevel(effectInstance.m_19564_());
                if (flag) {
                    capability.onStart(entity);
                } else {
                    capability.onEnd(entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity;
        if (event.getEntity() != null && (entity = event.getEntity()).m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        boolean cancelable = event.isCancelable();
        if (cancelable && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
            return;
        }
        ItemStack itemStack = event.getEntity().m_21205_();
        if (cancelable && itemStack.m_41720_() instanceof ItemDemolisher && ItemDemolisher.getWeaponState(itemStack) == 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        Player entity = event.getEntity();
        if (event.isCancelable() && entity.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.getPlayer().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (event.isCancelable() && living.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityKnockBack(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCancelable() && entity instanceof IBoss) {
            event.setStrength(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityMountEntity(EntityMountEvent event) {
        Entity entity = event.getEntityMounting();
        if (event.isCancelable() && entity instanceof IBoss) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityHurt(LivingHurtEvent event) {
        Player player;
        PlayerCapability.IPlayerCapability playerCapability;
        double chance;
        FrenzyCapability.IFrenzyCapability frenzyCapability;
        DamageSource source = event.getSource();
        Entity directEntity = source.m_7640_();
        LivingEntity hurtEntity = event.getEntity();
        if (directEntity instanceof EntityShamanBomb) {
            EntityShamanBomb shamanBomb = (EntityShamanBomb)directEntity;
            if (shamanBomb.reboundFlag && !shamanBomb.isPlayer()) {
                hurtEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 100, 0, false, false));
            }
        }
        if ((frenzyCapability = HandlerCapability.getCapability((Entity)hurtEntity, HandlerCapability.FRENZY_EFFECT_CAPABILITY)) != null && frenzyCapability.isFrenzy() && !source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO) && !source.m_269533_(DamageTypeTags.f_268490_)) {
            float damage = event.getAmount();
            if (hurtEntity.m_21223_() > 1.0f) {
                damage -= damage * Math.min((float)frenzyCapability.getLevel() + 1.0f, 5.0f) * 0.1f;
            }
            event.setAmount(damage);
        }
        AttributeInstance attribute = hurtEntity.m_21051_((Attribute)AttributeInit.CRIT_CHANCE.get());
        Entity attacker = source.m_7639_();
        if (attribute != null && attacker != null && (chance = attribute.m_22135_() - 1.0) > 0.0 && (double)hurtEntity.m_217043_().m_188501_() <= chance) {
            float damage = event.getAmount();
            if (source.m_269533_(EMTagKey.CAN_CRIT_HEAL) && attacker instanceof LivingEntity) {
                LivingEntity mob = (LivingEntity)attacker;
                float maxHealth = mob.m_21233_();
                mob.m_5634_(Math.min(damage * 0.3f + maxHealth * 0.01f, maxHealth * 0.1f));
            }
            event.setAmount(damage *= 1.5f);
            hurtEntity.m_9236_().m_6263_(null, hurtEntity.m_20185_(), hurtEntity.m_20186_(), hurtEntity.m_20189_(), SoundEvents.f_12313_, hurtEntity.m_5720_(), 1.0f, 1.0f);
            Level level = hurtEntity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8394_(attacker, (Packet)new ClientboundAnimatePacket((Entity)hurtEntity, 4));
            }
        }
        if (hurtEntity instanceof Player && (playerCapability = HandlerCapability.getCapability((Entity)(player = (Player)hurtEntity), HandlerCapability.PLAYER_CAPABILITY)) != null) {
            playerCapability.hurt(player, source, event.getAmount());
        }
    }

    @SubscribeEvent
    public void onLivingEntityHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = entity.m_21124_((MobEffect)EffectInit.ERODE_EFFECT.get());
        if (instance != null) {
            float newAmount = Mth.m_14036_((float)(1.0f - (float)(instance.m_19564_() + 1) * 0.1f), (float)0.0f, (float)1.0f);
            event.setAmount(event.getAmount() * newAmount);
        }
    }

    @SubscribeEvent
    public void onLivingEntityBreathe(LivingBreatheEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)EffectInit.FRENZY_EFFECT.get())) {
            event.setCanBreathe(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityChangeTarget(LivingChangeTargetEvent event) {
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityBloodBall bloodBall;
            EntityHitResult hitResult2 = (EntityHitResult)hitResult;
            if (projectile instanceof EntityBloodBall && !(bloodBall = (EntityBloodBall)projectile).isHeal() && hitResult2.m_82443_() instanceof EntityCorpseWarlock) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                return;
            }
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (arrow.m_36796_() == 0 && !arrow.m_5825_() && !arrow.m_6060_() && hitResult2.m_82443_() instanceof EntityImmortalExecutioner) {
                    arrow.m_20254_(100);
                }
                if (arrow.m_19749_() instanceof EntityAbsImmortal && hitResult2.m_82443_() instanceof EntityAbsImmortal && ((Boolean)EMConfigHandler.COMMON.OTHER.enableSameMobsTypeInjury.get()).booleanValue()) {
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                }
            }
        }
    }
}

