/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.animate.server.ai.AnimationMeleeAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.ai.animation.AnimationHurt;
import com.eeeab.animate.server.ai.animation.AnimationMelee;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.CopyOwnerTargetGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.ReFindOwnerGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.WhenOwnerDeadGoal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalShaman;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityImmortalGolem
extends EntityAbsImmortal
implements IEntity {
    public final Animation hurtAnimation = Animation.create(5);
    public final Animation attackAnimation = Animation.create(12);
    public final Animation spawnAnimation = Animation.create(20);
    private final Animation[] animations = new Animation[]{this.hurtAnimation, this.attackAnimation, this.spawnAnimation};
    private boolean boom;

    public EntityImmortalGolem(EntityType<? extends EntityImmortalGolem> type, Level level) {
        super((EntityType<? extends EntityAbsImmortal>)type, level);
        this.dropAfterDeathAnim = false;
        this.active = false;
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_NONE;
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_GOLEM.combatConfig;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, EntityImmortalShaman.class, 6.0f));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationActivate<EntityImmortalGolem>(this, () -> this.spawnAnimation));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityImmortalGolem>(this, () -> this.attackAnimation, 7, 1.5f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationHurt<EntityImmortalGolem>(this, false));
        this.f_21345_.m_25352_(2, new AnimationMeleeAI<EntityImmortalGolem>(this, 1.0, () -> this.attackAnimation));
        this.f_21345_.m_25352_(1, new ReFindOwnerGoal<EntityImmortalGolem>(this, EntityImmortalShaman.class, 20.0));
        this.f_21346_.m_25352_(2, new CopyOwnerTargetGoal<EntityImmortalGolem>(this));
        this.f_21345_.m_25352_(3, new WhenOwnerDeadGoal<EntityImmortalGolem>(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (this.isDangerous() && this.getAnimation() == this.attackAnimation && this.getAnimationTick() == 6) {
            this.boom();
        }
        if (this.isDangerous() && this.m_6060_()) {
            this.boom();
        }
    }

    private void boom() {
        if (!this.m_9236_().f_46443_ && !this.boom) {
            this.boom = true;
            this.m_9236_().m_7605_((Entity)this, (byte)5);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Level.ExplosionInteraction.NONE);
            this.m_6074_();
        }
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 5) {
            ModParticleUtils.roundParticleOutburst(this.m_9236_(), 10.0, new ParticleOptions[]{ParticleTypes.f_123755_, ParticleTypes.f_123762_}, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0.5f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    protected void m_147246_() {
        if (!this.isDangerous()) {
            super.m_147246_();
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        Entity sourceSource = source.m_7639_();
        if (!(sourceSource == null || this.m_5448_() != null || !(sourceSource instanceof LivingEntity) || sourceSource instanceof Player && ((Player)sourceSource).m_7500_() || ((LivingEntity)sourceSource).m_6336_() == this.m_6336_())) {
            this.m_6710_((LivingEntity)sourceSource);
        }
        return super.m_6469_(source, damage);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_150930_(Items.f_42409_)) {
            this.boom();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        RandomSource randomsource = worldIn.m_213780_();
        this.m_213945_(randomsource, difficultyIn);
        return spawnDataIn;
    }

    protected void m_213945_(RandomSource p_217055_, DifficultyInstance p_217056_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22281_, 2.5);
    }

    @Override
    public Animation getSpawnAnimation() {
        return this.spawnAnimation;
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    @Override
    public Animation getHurtAnimation() {
        return this.hurtAnimation;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.IMMORTAL_GOLEM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.IMMORTAL_GOLEM_DEATH.get();
    }

    public boolean isDangerous() {
        return this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_41996_) || this.m_21120_(InteractionHand.OFF_HAND).m_150930_(Items.f_41996_);
    }

    public void setDangerous(boolean dangerous) {
        if (dangerous) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41996_));
        }
    }
}

