/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityAbsBeam;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityImmortalLaser
extends EntityAbsBeam {
    public static final double IMMORTAL_RADIUS = 32.0;
    public static final double RENDER_DISTANCE = 2048.0;
    private static final float MAX_RADIANS = 0.61086524f;
    private static final float ROTATION_SPEED = 0.061086524f;
    private static final EntityDataAccessor<Boolean> DATA_PLAY_SOUND = SynchedEntityData.m_135353_(EntityImmortalLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isRotating = true;

    public EntityImmortalLaser(EntityType<? extends EntityImmortalLaser> type, Level level) {
        super(type, level, 1);
    }

    public EntityImmortalLaser(Level world, LivingEntity caster, double x, double y, double z, float yaw, int duration, boolean canPlaySound) {
        this((EntityType<? extends EntityImmortalLaser>)((EntityType)EntityInit.IMMORTAL_LASER.get()), world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(-1.5707964f);
        this.setDuration(duration);
        this.m_6034_(x, y, z);
        this.calculateEndPos(32.0);
        this.m_20088_().m_135381_(DATA_PLAY_SOUND, (Object)canPlaySound);
        if (!this.m_9236_().f_46443_) {
            this.setCasterId(caster.m_19879_());
        }
    }

    @Override
    protected void beamTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ == 1 && ((Boolean)this.f_19804_.m_135370_(DATA_PLAY_SOUND)).booleanValue()) {
            EEEABMobs.PROXY.playImmortalLaserSound(this);
        }
        if (this.f_19797_ >= this.getCountDown()) {
            this.calculateEndPos(32.0);
            if (this.isRotating) {
                float newPitch = this.getPitch() + 0.061086524f;
                if (newPitch >= 0.61086524f) {
                    newPitch = 0.61086524f;
                    this.isRotating = false;
                }
                this.setPitch(newPitch);
            }
            List<LivingEntity> entities = this.raytraceEntities(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ)).getEntities();
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : entities) {
                    boolean hurtFlag = false;
                    DamageSource indirectMagic = this.m_269291_().m_269104_((Entity)this, (Entity)this.caster);
                    LivingEntity livingEntity = this.caster;
                    if (livingEntity instanceof EntityImmortal) {
                        EntityImmortal immortal = (EntityImmortal)livingEntity;
                        float damageMultiplier = 0.0f;
                        MobEffectInstance instance = target.m_21124_((MobEffect)EffectInit.ERODE_EFFECT.get());
                        if (instance != null) {
                            damageMultiplier += (float)(instance.m_19564_() + 1) * 0.08f;
                        }
                        hurtFlag = immortal.doHurtTarget(indirectMagic, target, false, false, false, 0.03f, 0.375f, 1.0f + damageMultiplier);
                    } else if (this.caster != null) {
                        hurtFlag = target.m_6469_(indirectMagic, 5.0f + target.m_21233_() * 0.01f);
                    }
                    if (!hurtFlag) continue;
                    ModEntityUtils.addEffectStackingAmplifier(this, target, (MobEffect)EffectInit.ERODE_EFFECT.get(), 300, 5, true, true, true, true, true);
                }
            } else if (this.f_19797_ > this.getCountDown()) {
                this.spawnExplosionParticles();
            }
        }
    }

    @Override
    protected void spawnExplosionParticles() {
        if (this.blockSide != null) {
            for (int i = 0; i < 2; ++i) {
                float velocity = 0.2f;
                float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
                float motionY = this.f_19796_.m_188501_() * -0.2f;
                float motionX = 0.2f * Mth.m_14089_((float)yaw);
                float motionZ = 0.2f * Mth.m_14031_((float)yaw);
                Vec3i normal = this.blockSide.m_122436_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleInit.IMMORTAL_EXPLOSION.get(), this.prevCollidePosX + (double)normal.m_123341_(), this.prevCollidePosY + (double)normal.m_123342_() * 0.5, this.prevCollidePosZ + (double)normal.m_123343_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.prevCollidePosX + (double)normal.m_123341_(), this.prevCollidePosY + (double)normal.m_123342_() * 0.5, this.prevCollidePosZ + (double)normal.m_123343_(), (double)motionX, (double)motionY, (double)motionZ);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PLAY_SOUND, (Object)false);
    }

    @Override
    protected float getBaseScale() {
        return 0.3f;
    }

    public boolean m_6783_(double distance) {
        return distance < 2048.0;
    }
}

