/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.client.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ItemAnimationUtils {
    private static final String ACCUMULATED_TIME_KEY = "accumulatedTime";
    private static final String ANIMATION_INDEX = "animationIndex";
    private static final String LAST_TIME_KEY = "lastTime";

    public static CompoundTag start(ItemStack stack, int tickCount) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(LAST_TIME_KEY, (long)tickCount * 1000L / 20L);
        tag.m_128356_(ACCUMULATED_TIME_KEY, 0L);
        return tag;
    }

    public static void start(ItemStack stack, int tickCount, int index) {
        ItemAnimationUtils.start(stack, tickCount).m_128405_(ANIMATION_INDEX, index);
    }

    public static boolean updateTime(ItemStack stack, float ageInTicks, float speed) {
        boolean flag = ItemAnimationUtils.isStarted(stack);
        if (flag) {
            CompoundTag tag = stack.m_41784_();
            long i = Mth.m_14134_((double)(ageInTicks * 1000.0f / 20.0f));
            long lastTime = tag.m_128454_(LAST_TIME_KEY);
            tag.m_128356_(ACCUMULATED_TIME_KEY, tag.m_128454_(ACCUMULATED_TIME_KEY) + (long)((float)(i - lastTime) * speed));
            tag.m_128356_(LAST_TIME_KEY, i);
        }
        return flag;
    }

    public static void stop(ItemStack stack) {
        stack.m_41784_().m_128356_(LAST_TIME_KEY, Long.MAX_VALUE);
    }

    public static long getAccumulatedTime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128454_(ACCUMULATED_TIME_KEY) : 0L;
    }

    public static int getAnimationIndex(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(ANIMATION_INDEX) : 0;
    }

    public static boolean isStarted(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128454_(LAST_TIME_KEY) != Long.MAX_VALUE;
    }
}

