/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.medievalend.shared.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JigsawStructure.class})
public abstract class JigsawStructureMix {
    @Shadow
    @Final
    private Holder<StructureTemplatePool> f_227605_;

    @Inject(method={"findGenerationPoint"}, at={@At(value="RETURN")}, cancellable=true)
    private void getStructurePosition(Structure.GenerationContext context, CallbackInfoReturnable<Optional<Structure.GenerationStub>> cir) {
        String string = this.f_227605_.toString();
        if (string.contains("medievalend")) {
            Optional position = (Optional)cir.getReturnValue();
            if (position.isEmpty()) {
                return;
            }
            BlockPos pos = ((Structure.GenerationStub)position.get()).f_226669_();
            if (pos.m_123342_() < 40) {
                cir.setReturnValue(Optional.empty());
                return;
            }
            if (string.contains("pyramid") || string.contains("castle")) {
                BlockPos centerAtY = context.f_226628_().m_151394_(0);
                for (int i = 1; i <= 2; ++i) {
                    for (Direction direction2 : Direction.values()) {
                        if (direction2 == Direction.DOWN) continue;
                        for (Direction direction1 : Direction.values()) {
                            int topY;
                            if (direction1 == Direction.DOWN || direction1 == direction2) continue;
                            NoiseColumn sample = context.f_226622_().m_214184_(centerAtY.m_123341_() + i * 16 * (direction1.m_122436_().m_123341_() + direction2.m_122436_().m_123341_()), centerAtY.m_123343_() + i * 16 * (direction1.m_122436_().m_123343_() + direction2.m_122436_().m_123343_()), context.f_226629_(), context.f_226624_());
                            for (topY = 75; topY > 0; --topY) {
                                BlockState state = sample.m_183556_(topY);
                                if (state.m_60795_()) {
                                    continue;
                                }
                                if (!state.m_60713_(Blocks.f_49990_)) break;
                                cir.setReturnValue(Optional.empty());
                                return;
                            }
                            if (Math.abs(pos.m_123342_() - topY) <= 5) continue;
                            cir.setReturnValue(Optional.empty());
                            return;
                        }
                    }
                }
            }
        }
    }
}

