/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.utils.ColorUtils;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidUtils {
    public static ConcurrentHashMap<ResourceLocation, Integer> colorCache = new ConcurrentHashMap();

    public static int getFluidColor(FluidStack stack) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        ResourceLocation location = renderProperties.getStillTexture(stack);
        int tint = renderProperties.getTintColor(stack);
        int textureColor = colorCache.computeIfAbsent(location, ColorUtils::getColorFrom);
        return FastColor.ARGB32.m_13657_((int)textureColor, (int)tint);
    }

    public static int getFluidColor(Fluid fluid) {
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation location = renderProperties.getStillTexture();
        int tint = renderProperties.getTintColor();
        int textureColor = colorCache.computeIfAbsent(location, ColorUtils::getColorFrom);
        return FastColor.ARGB32.m_13657_((int)textureColor, (int)tint);
    }
}

