/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RangeManager {
    private BlockPos current;
    private AABB box;
    private RangeType type;
    private Direction direction;

    public RangeManager(BlockPos current, Direction facing, RangeType rangeType) {
        this.current = current;
        this.type = rangeType;
        this.direction = facing;
        this.box = rangeType.getOffsetCreation().apply(facing, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(current));
    }

    public VoxelShape get(int range) {
        return Shapes.m_83064_((AABB)this.type.getOffsetRange().apply(this, range));
    }

    public BlockPos getCurrent() {
        return this.current;
    }

    public AABB getBox() {
        return this.box;
    }

    public RangeType getType() {
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static enum RangeType {
        FRONT((direction, axisAlignedBB) -> axisAlignedBB.m_82386_((double)direction.m_122436_().m_123341_(), (double)direction.m_122436_().m_123342_(), (double)direction.m_122436_().m_123343_()), (rangeManager, integer) -> rangeManager.getBox().m_82386_((double)(rangeManager.getDirection().m_122436_().m_123341_() * integer), (double)(rangeManager.getDirection().m_122436_().m_123342_() * integer), (double)(rangeManager.getDirection().m_122436_().m_123343_() * integer)).m_82377_((double)integer.intValue(), 0.0, (double)integer.intValue())),
        BEHIND((direction, axisAlignedBB) -> axisAlignedBB.m_82386_((double)direction.m_122424_().m_122436_().m_123341_(), (double)direction.m_122424_().m_122436_().m_123342_(), (double)direction.m_122424_().m_122436_().m_123343_()), (rangeManager, integer) -> rangeManager.getBox().m_82386_((double)(rangeManager.getDirection().m_122424_().m_122436_().m_123341_() * integer), (double)(rangeManager.getDirection().m_122424_().m_122436_().m_123342_() * integer), (double)(rangeManager.getDirection().m_122424_().m_122436_().m_123343_() * integer)).m_82377_((double)integer.intValue(), 0.0, (double)integer.intValue())),
        TOP((direction, axisAlignedBB) -> axisAlignedBB.m_82386_(0.0, 1.0, 0.0), (rangeManager, integer) -> rangeManager.getBox().m_82377_((double)integer.intValue(), 0.0, (double)integer.intValue())),
        TOP_UP((direction, axisAlignedBB) -> axisAlignedBB.m_82386_(0.0, 2.0, 0.0), (rangeManager, integer) -> rangeManager.getBox().m_82377_((double)integer.intValue(), 0.0, (double)integer.intValue())),
        BOTTOM((direction, axisAlignedBB) -> axisAlignedBB.m_82386_(0.0, -1.0, 0.0), (rangeManager, integer) -> rangeManager.getBox().m_82377_((double)integer.intValue(), 0.0, (double)integer.intValue()));

        private final BiFunction<Direction, AABB, AABB> offsetCreation;
        private final BiFunction<RangeManager, Integer, AABB> offsetRange;

        private RangeType(BiFunction<Direction, AABB, AABB> offsetCreation, BiFunction<RangeManager, Integer, AABB> offsetRange) {
            this.offsetCreation = offsetCreation;
            this.offsetRange = offsetRange;
        }

        public BiFunction<Direction, AABB, AABB> getOffsetCreation() {
            return this.offsetCreation;
        }

        public BiFunction<RangeManager, Integer, AABB> getOffsetRange() {
            return this.offsetRange;
        }
    }
}

