/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.configuration;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endercrop", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EnderCropConfiguration {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.DoubleValue tilledSoilMultiplier;
    public static ForgeConfigSpec.DoubleValue tilledEndMultiplier;
    public static ForgeConfigSpec.BooleanValue tilledEndStone;
    public static ForgeConfigSpec.IntValue miteChance;
    public static ForgeConfigSpec.BooleanValue endstoneNeedsUnbreaking;
    public static ForgeConfigSpec.IntValue hoeToolHarvestLevelEndstone;

    public static void buildConfig(ForgeConfigSpec.Builder builder) {
        tilledSoilMultiplier = builder.comment(new String[]{"Crop growth multiplier on tilled soil, this value multiplies default vanilla growth rate", "e.g. 10.5 -> Ten and a half times the speed of vanilla crop."}).defineInRange("tilledSoilMultiplier", 0.5, 0.0, 25.0);
        tilledEndMultiplier = builder.comment(new String[]{"Crop growth multiplier on tilled end stone, this value multiplies default vanilla growth rate", "e.g. 10.5 -> Ten and a half times the speed of vanilla crop"}).defineInRange("tilledEndMultiplier", 1.0, 0.0, 25.0);
        tilledEndStone = builder.comment("Enable Tilled End Stone").define("tilledEndStone", true);
        miteChance = builder.comment(new String[]{"Chance to spawn endermite when harvesting an Ender Crop on Tilled End Stone (1 in ...)", "0 to disable"}).defineInRange("miteChance", 50, 0, Integer.MAX_VALUE);
        endstoneNeedsUnbreaking = builder.comment("Is a hoe enchanted with Unbreaking (I) needed to till endstone?").define("endstoneNeedsUnbreaking", true);
        hoeToolHarvestLevelEndstone = builder.comment("Minimum non-vanilla hoe tool (e.g. TiCo Kama) material level needed to till endstone").defineInRange("hoeToolHarvestLevelEndstone", 1, 0, 20);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        EnderCropConfiguration.buildConfig(builder);
        COMMON_CONFIG = builder.build();
    }
}

