/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.compat;

import io.github.drmanganese.endercrop.HoeHelper;
import io.github.drmanganese.endercrop.block.EnderCropBlock;
import io.github.drmanganese.endercrop.configuration.EnderCropConfiguration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.SubTextElement;

@WailaPlugin
public class WailaCompatibility
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)EnderCropGrowthProvider.INSTANCE, EnderCropBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)EndStoneTillingProvider.INSTANCE, Block.class);
    }

    public static enum EnderCropGrowthProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
            EnderCropBlock enderCrop = (EnderCropBlock)blockAccessor.getBlock();
            if (!enderCrop.m_52307_(blockAccessor.getBlockState()) && !enderCrop.isDarkEnough(blockAccessor.getLevel(), blockAccessor.getPosition())) {
                tooltip.add((Component)Component.m_237115_((String)"endercrop.wailatop.nogrowth").m_130940_(ChatFormatting.RED));
                if (blockAccessor.getPlayer().m_6047_()) {
                    int lightLevel = blockAccessor.getLevel().m_45524_(blockAccessor.getPosition(), 0);
                    tooltip.add((Component)Component.m_237115_((String)"endercrop.wailatop.light").m_130946_(": ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(lightLevel + " (>7)")).m_130940_(ChatFormatting.RED)));
                }
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("endercrop:endercrop");
        }
    }

    public static enum EndStoneTillingProvider implements IBlockComponentProvider
    {
        INSTANCE;

        private static final Component CHECK;
        private static final Component X;
        private static final ItemStack HOE;

        public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
            ItemStack hoeStack;
            IElementHelper elements = tooltip.getElementHelper();
            if (blockAccessor.getBlock().equals(Blocks.f_50259_) && ((Boolean)EnderCropConfiguration.tilledEndStone.get()).booleanValue() && !(hoeStack = HoeHelper.holdingHoeTool(blockAccessor.getPlayer())).m_41619_()) {
                boolean canTill = HoeHelper.canHoeEndstone(hoeStack, blockAccessor.getPlayer(), blockAccessor.getBlockState());
                tooltip.add(elements.item(HOE, 0.75f).size(new Vec2(10.0f, 13.0f)).translate(new Vec2(0.0f, -2.0f)));
                tooltip.append(new SubTextElement(canTill ? CHECK : X).translate(new Vec2(-3.5f, 6.0f)));
                tooltip.append(elements.spacer(4, 0));
                tooltip.append(elements.text((Component)Component.m_237113_((String)"Till").m_7220_(this.unbreakingHint(canTill))).translate(new Vec2(0.0f, 2.0f)));
            }
        }

        private Component unbreakingHint(boolean canTill) {
            if (((Boolean)EnderCropConfiguration.endstoneNeedsUnbreaking.get()).booleanValue() && !canTill) {
                return Component.m_237113_((String)" (").m_7220_((Component)Component.m_237115_((String)"enchantment.minecraft.unbreaking").m_130946_(" I+").m_130940_(ChatFormatting.RED)).m_130946_(")");
            }
            return Component.m_237119_();
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("endercrop", "endstone");
        }

        static {
            CHECK = Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN);
            X = Component.m_237113_((String)"\u2715").m_130940_(ChatFormatting.RED);
            HOE = new ItemStack((ItemLike)Items.f_42424_);
        }
    }
}

