/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.compat;

import com.google.common.base.Function;
import io.github.drmanganese.endercrop.HoeHelper;
import io.github.drmanganese.endercrop.block.EnderCropBlock;
import io.github.drmanganese.endercrop.block.TilledEndstoneBlock;
import io.github.drmanganese.endercrop.configuration.EnderCropConfiguration;
import io.github.drmanganese.endercrop.init.ModBlocks;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.InterModComms;

public final class TOPCompatibility
implements Function<ITheOneProbe, Void> {
    public static ITheOneProbe probe;

    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"GetTheOneProbe", TOPCompatibility::new);
    }

    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        probe = theOneProbe;
        probe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("endercrop");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
                ItemStack hoeStack;
                if (blockState.m_60713_((Block)ModBlocks.TILLED_END_STONE.get())) {
                    if (mode == ProbeMode.EXTENDED) {
                        if ((Integer)blockState.m_61143_((Property)TilledEndstoneBlock.f_53243_) == 7) {
                            probeInfo.text(CompoundText.create().label("{*endercrop.wailatop.moist*}"));
                        } else {
                            probeInfo.text(CompoundText.create().label("{*endercrop.wailatop.dry*}"));
                        }
                    }
                    if (mode == ProbeMode.DEBUG) {
                        probeInfo.text(CompoundText.create().labelInfo("MOISTURE: ", (Object)blockState.m_61143_((Property)TilledEndstoneBlock.f_53243_)));
                    }
                } else if (blockState.m_60713_((Block)ModBlocks.ENDER_CROP.get())) {
                    EnderCropBlock enderCrop = (EnderCropBlock)blockState.m_60734_();
                    if (!enderCrop.m_52307_(blockState) && !enderCrop.isDarkEnough(world, data.getPos())) {
                        probeInfo.text(CompoundText.create().error("{*endercrop.wailatop.nogrowth*}"));
                        if (mode == ProbeMode.EXTENDED) {
                            int lightLevel = world.m_45524_(data.getPos(), 0);
                            probeInfo.text(CompoundText.create().label("{*endercrop.wailatop.light*}: ").info(String.valueOf(lightLevel)).error(" (>7)"));
                        }
                    }
                } else if (blockState.m_60713_(Blocks.f_50259_) && ((Boolean)EnderCropConfiguration.tilledEndStone.get()).booleanValue() && !(hoeStack = HoeHelper.holdingHoeTool(player)).m_41619_()) {
                    IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                    if (HoeHelper.canHoeEndstone(hoeStack, player, blockState)) {
                        hori.icon(new ResourceLocation("theoneprobe", "textures/gui/icons.png"), 0, 16, 13, 13, probeInfo.defaultIconStyle().width(18).height(14).textureWidth(32).textureHeight(32));
                        hori.text(CompoundText.create().ok("{*endercrop.top.hoe*}"));
                    } else {
                        hori.icon(new ResourceLocation("theoneprobe", "textures/gui/icons.png"), 16, 16, 13, 13, probeInfo.defaultIconStyle().width(18).height(14).textureWidth(32).textureHeight(32));
                        if (hoeStack.m_41720_() instanceof HoeItem) {
                            hori.text(CompoundText.create().warning("{*endercrop.top.hoe*}" + ((Boolean)EnderCropConfiguration.endstoneNeedsUnbreaking.get() != false ? " ({*enchantment.minecraft.unbreaking*} I+)" : "")));
                        } else {
                            hori.text(CompoundText.create().warning("{*endercrop.top.hoe*}").warning(" (").text(HoeHelper.getHarvestLevelInfo(hoeStack)).warning(")"));
                        }
                    }
                }
            }
        });
        return null;
    }
}

