/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.block;

import io.github.drmanganese.endercrop.configuration.EnderCropConfiguration;
import io.github.drmanganese.endercrop.init.ModBlocks;
import io.github.drmanganese.endercrop.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class EnderCropBlock
extends CropBlock {
    private static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_);

    public EnderCropBlock() {
        super(PROPERTIES);
    }

    private static boolean isOnEndstone(LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60713_((Block)ModBlocks.TILLED_END_STONE.get());
    }

    protected static float getGrowthSpeed(Block blockIn, Level worldIn, BlockPos pos) {
        float baseChance = CropBlock.m_52272_((Block)blockIn, (BlockGetter)worldIn, (BlockPos)pos);
        baseChance = EnderCropBlock.isOnEndstone((LevelReader)worldIn, pos) ? (float)((double)baseChance * (Double)EnderCropConfiguration.tilledEndMultiplier.get()) : (float)((double)baseChance * (Double)EnderCropConfiguration.tilledSoilMultiplier.get());
        return baseChance;
    }

    @Nonnull
    protected ItemLike m_6404_() {
        return (ItemLike)ModItems.ENDER_SEEDS.get();
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_) || state.m_60713_((Block)ModBlocks.TILLED_END_STONE.get());
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        boolean lightCheck = EnderCropBlock.isOnEndstone(pLevel, pPos) ? pLevel.m_45524_(pPos, 0) >= 8 || pLevel.m_45527_(pPos) : pLevel.m_45524_(pPos, 0) <= 7;
        BlockPos below = pPos.m_7495_();
        if (pState.m_60734_() == this) {
            return lightCheck && pLevel.m_8055_(below).canSustainPlant((BlockGetter)pLevel, below, Direction.UP, (IPlantable)this);
        }
        return lightCheck && this.m_6266_(pLevel.m_8055_(below), (BlockGetter)pLevel, below);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return false;
    }

    protected int m_7125_(Level pLevel) {
        return 0;
    }

    public boolean isDarkEnough(Level worldIn, BlockPos pos) {
        return EnderCropBlock.isOnEndstone((LevelReader)worldIn, pos) || worldIn.m_45524_(pos, 0) <= 7;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.isDarkEnough((Level)level, pos)) {
            float growthChance;
            int age = this.m_52305_(state);
            if (!this.m_52307_(state) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (growthChance = EnderCropBlock.getGrowthSpeed((Block)this, (Level)level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, this.m_52289_(age + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Endermite mite;
        int roll;
        boolean destroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (destroyed && (Integer)EnderCropConfiguration.miteChance.get() > 0 && EnderCropBlock.isOnEndstone((LevelReader)level, pos) && this.m_52307_(state) && (roll = level.f_46441_.m_188503_(((Integer)EnderCropConfiguration.miteChance.get()).intValue())) == 0 && (mite = (Endermite)EntityType.f_20567_.m_20615_(level)) != null) {
            mite.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            mite.m_5618_(Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)));
            mite.m_6710_((LivingEntity)player);
            level.m_7967_((Entity)mite);
        }
        return destroyed;
    }
}

