/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop;

import io.github.drmanganese.endercrop.configuration.EnderCropConfiguration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public final class HoeHelper {
    public static boolean canHoeEndstone(@Nonnull ItemStack itemStack, @Nullable Player player, @Nullable BlockState blockState) {
        Item item = itemStack.m_41720_();
        if (player != null && player.m_7500_()) {
            return true;
        }
        if (item instanceof HoeItem) {
            return itemStack.getEnchantmentLevel(Enchantments.f_44986_) > 0 || (Boolean)EnderCropConfiguration.endstoneNeedsUnbreaking.get() == false;
        }
        return false;
    }

    public static boolean isHoe(@Nonnull ItemStack itemStack) {
        return itemStack.m_41720_() instanceof HoeItem;
    }

    public static ItemStack holdingHoeTool(@Nonnull Player player) {
        for (InteractionHand enumHand : InteractionHand.values()) {
            ItemStack itemStack = player.m_21120_(enumHand);
            if (!HoeHelper.isHoe(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static Component getHarvestLevelInfo(ItemStack itemStack) {
        int requiredLevel = (Integer)EnderCropConfiguration.hoeToolHarvestLevelEndstone.get();
        MutableComponent defaultText = Component.m_237113_((String)String.valueOf(requiredLevel));
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).m_135827_().equals("tconstruct")) {
            return HoeHelper.getHarvestLevelName(requiredLevel).orElse((Component)defaultText);
        }
        return defaultText;
    }

    public static Optional<Component> getHarvestLevelName(int i) {
        return Optional.empty();
    }

    public static MutableComponent getToolErrorMessage(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof HoeItem) {
            return Component.m_237115_((String)"endercrop.alert.hoe");
        }
        return Component.m_237110_((String)"endercrop.alert.hoetool", (Object[])new Object[]{HoeHelper.getHarvestLevelInfo(itemStack)});
    }
}

