/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin;

import java.util.Map;
import net.bettercombat.api.AttackHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentMixin {
    @Inject(method={"getEquipment"}, at={@At(value="RETURN")}, cancellable=true)
    private void getEquipmentFix(LivingEntity entity, CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir) {
        int comboCount;
        Player player;
        AttackHand currentHand;
        if (entity instanceof Player && (currentHand = PlayerAttackHelper.getCurrentAttack(player = (Player)entity, comboCount = ((PlayerAttackProperties)player).getComboCount())) != null && currentHand.isOffHand()) {
            ItemStack offHandStack;
            Map map = (Map)cir.getReturnValue();
            if (map.get(EquipmentSlot.MAINHAND) != null) {
                map.remove(EquipmentSlot.MAINHAND);
            }
            if (!(offHandStack = player.m_21206_()).m_41619_()) {
                map.put(EquipmentSlot.OFFHAND, offHandStack);
            }
            cir.setReturnValue((Object)map);
        }
    }
}

