/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import java.util.Map;

public class MapEntry<K, V>
implements Map.Entry<K, V> {
    private K key;
    private V value;

    public static <T, R> MapEntry<T, R> of(T key, R value) {
        return new MapEntry<T, R>(key, value);
    }

    public static <T, R> MapEntry<T, R> ofUnmodifiable(T key, R value) {
        return new MapEntry<T, R>(key, value){

            @Override
            public final R setValue(R value) {
                throw new UnsupportedOperationException("The key can't be modified");
            }

            @Override
            public final T setKey(T key) {
                throw new UnsupportedOperationException("The value can't be modified");
            }
        };
    }

    public MapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        this.value = value;
        return this.value;
    }

    public K setKey(K key) {
        this.key = key;
        return this.key;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)obj;
        return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }
}

