/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import com.hypherionmc.simplerpc.jodd.util.Wildcard;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class InExRules<V, P> {
    public static final Function<String, Predicate<String>> WILDCARD_STRING_MATCHER = pattern -> new Predicate<String>(){
        final String p;
        {
            this.p = pattern;
        }

        @Override
        public boolean test(String value) {
            return Wildcard.match(value, this.p);
        }
    };
    private final InExType inExType;
    private final Function<P, Predicate<V>> factory;
    private final List<Predicate<V>> includePatterns = new ArrayList<Predicate<V>>();
    private final List<Predicate<V>> excludePatterns = new ArrayList<Predicate<V>>();

    public static InExRules<String, String> blacklist() {
        return new InExRules<String, String>(InExType.BLACKLIST, WILDCARD_STRING_MATCHER);
    }

    public static InExRules<String, String> whitelist() {
        return new InExRules<String, String>(InExType.WHITELIST, WILDCARD_STRING_MATCHER);
    }

    public InExRules(InExType inExType, Function<P, Predicate<V>> factory) {
        this.inExType = inExType;
        this.factory = factory;
    }

    public void include(P pattern) {
        Predicate<V> matcher = this.factory.apply(pattern);
        this.includePatterns.add(matcher);
    }

    public void exclude(P pattern) {
        Predicate<V> matcher = this.factory.apply(pattern);
        this.excludePatterns.add(matcher);
    }

    public boolean match(V value) {
        boolean flag;
        boolean bl = flag = this.inExType == InExType.BLACKLIST;
        if (this.inExType == InExType.BLACKLIST) {
            flag = this.processExcludes(value, flag);
            flag = this.processIncludes(value, flag);
        } else {
            flag = this.processIncludes(value, flag);
            flag = this.processExcludes(value, flag);
        }
        return flag;
    }

    public boolean apply(V value, boolean flag) {
        if (this.inExType == InExType.BLACKLIST) {
            flag = this.processExcludes(value, flag);
            flag = this.processIncludes(value, flag);
        } else {
            flag = this.processIncludes(value, flag);
            flag = this.processExcludes(value, flag);
        }
        return flag;
    }

    protected boolean processIncludes(V value, boolean include) {
        if (this.includePatterns.isEmpty()) {
            return include;
        }
        if (include) {
            return include;
        }
        for (Predicate<V> includePredicate : this.includePatterns) {
            if (!includePredicate.test(value)) continue;
            include = true;
            break;
        }
        return include;
    }

    protected boolean processExcludes(V value, boolean include) {
        if (this.excludePatterns.isEmpty()) {
            return include;
        }
        if (!include) {
            return include;
        }
        for (Predicate<V> excludePredicate : this.excludePatterns) {
            if (!excludePredicate.test(value)) continue;
            include = false;
            break;
        }
        return include;
    }

    public static enum InExType {
        WHITELIST,
        BLACKLIST;

    }
}

