/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.BigDecimalConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.BigIntegerConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.BooleanArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.BooleanConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ByteArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ByteConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.CalendarConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.CharacterArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.CharacterConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ClassArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ClassConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.CollectionConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.DateConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.DoubleArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.DoubleConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.FileConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.FloatArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.FloatConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.IntegerArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.IntegerConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.LocalDateConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.LocalDateTimeConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.LocalTimeConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.LocaleConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.LongArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.LongConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ShortArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.ShortConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.SqlDateConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.SqlTimeConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.SqlTimestampConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.StringArrayConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.StringConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.TimeZoneConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.URIConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.URLConverter;
import com.hypherionmc.simplerpc.jodd.typeconverter.impl.UUIDConverter;
import com.hypherionmc.simplerpc.jodd.util.ClassUtil;
import com.hypherionmc.simplerpc.jodd.util.TypeCache;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class TypeConverterManager {
    private static final TypeConverterManager TYPE_CONVERTER_MANAGER = new TypeConverterManager();
    private final TypeCache<TypeConverter> converters = TypeCache.createDefault();

    public static TypeConverterManager get() {
        return TYPE_CONVERTER_MANAGER;
    }

    public TypeConverterManager() {
        this.registerDefaults();
    }

    public void registerDefaults() {
        this.register(String.class, new StringConverter());
        this.register(String[].class, new StringArrayConverter(this));
        IntegerConverter integerConverter = new IntegerConverter();
        this.register(Integer.class, integerConverter);
        this.register(Integer.TYPE, integerConverter);
        ShortConverter shortConverter = new ShortConverter();
        this.register(Short.class, shortConverter);
        this.register(Short.TYPE, shortConverter);
        LongConverter longConverter = new LongConverter();
        this.register(Long.class, longConverter);
        this.register(Long.TYPE, longConverter);
        ByteConverter byteConverter = new ByteConverter();
        this.register(Byte.class, byteConverter);
        this.register(Byte.TYPE, byteConverter);
        FloatConverter floatConverter = new FloatConverter();
        this.register(Float.class, floatConverter);
        this.register(Float.TYPE, floatConverter);
        DoubleConverter doubleConverter = new DoubleConverter();
        this.register(Double.class, doubleConverter);
        this.register(Double.TYPE, doubleConverter);
        BooleanConverter booleanConverter = new BooleanConverter();
        this.register(Boolean.class, booleanConverter);
        this.register(Boolean.TYPE, booleanConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        this.register(Character.class, characterConverter);
        this.register(Character.TYPE, characterConverter);
        this.register(byte[].class, new ByteArrayConverter(this));
        this.register(short[].class, new ShortArrayConverter(this));
        this.register(int[].class, new IntegerArrayConverter(this));
        this.register(long[].class, new LongArrayConverter(this));
        this.register(float[].class, new FloatArrayConverter(this));
        this.register(double[].class, new DoubleArrayConverter(this));
        this.register(boolean[].class, new BooleanArrayConverter(this));
        this.register(char[].class, new CharacterArrayConverter(this));
        this.register(Integer[].class, new ArrayConverter<Integer>(this, Integer.class){

            protected Integer[] createArray(int length) {
                return new Integer[length];
            }
        });
        this.register(Long[].class, new ArrayConverter<Long>(this, Long.class){

            protected Long[] createArray(int length) {
                return new Long[length];
            }
        });
        this.register(Byte[].class, new ArrayConverter<Byte>(this, Byte.class){

            protected Byte[] createArray(int length) {
                return new Byte[length];
            }
        });
        this.register(Short[].class, new ArrayConverter<Short>(this, Short.class){

            protected Short[] createArray(int length) {
                return new Short[length];
            }
        });
        this.register(Float[].class, new ArrayConverter<Float>(this, Float.class){

            protected Float[] createArray(int length) {
                return new Float[length];
            }
        });
        this.register(Double[].class, new ArrayConverter<Double>(this, Double.class){

            protected Double[] createArray(int length) {
                return new Double[length];
            }
        });
        this.register(Boolean[].class, new ArrayConverter<Boolean>(this, Boolean.class){

            protected Boolean[] createArray(int length) {
                return new Boolean[length];
            }
        });
        this.register(Character[].class, new ArrayConverter<Character>(this, Character.class){

            protected Character[] createArray(int length) {
                return new Character[length];
            }
        });
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
        this.register(BigDecimal[].class, new ArrayConverter<BigDecimal>(this, BigDecimal.class));
        this.register(BigInteger[].class, new ArrayConverter<BigInteger>(this, BigInteger.class));
        this.register(java.util.Date.class, new DateConverter());
        this.register(Date.class, new SqlDateConverter());
        this.register(Time.class, new SqlTimeConverter());
        this.register(Timestamp.class, new SqlTimestampConverter());
        this.register(Calendar.class, new CalendarConverter());
        this.register(LocalDateTime.class, new LocalDateTimeConverter());
        this.register(LocalDate.class, new LocalDateConverter());
        this.register(LocalTime.class, new LocalTimeConverter());
        this.register(File.class, new FileConverter());
        this.register(Class.class, new ClassConverter());
        this.register(Class[].class, new ClassArrayConverter(this));
        this.register(URI.class, new URIConverter());
        this.register(URL.class, new URLConverter());
        this.register(Locale.class, new LocaleConverter());
        this.register(TimeZone.class, new TimeZoneConverter());
        this.register(UUID.class, new UUIDConverter());
    }

    public <T> void register(Class<T> type, TypeConverter<T> typeConverter) {
        this.converters.put(type, typeConverter);
    }

    public void unregister(Class type) {
        this.converters.remove(type);
    }

    public <T> TypeConverter<T> lookup(Class<T> type) {
        return this.converters.get(type);
    }

    public <T> T convertType(Object value, Class<T> destinationType) {
        if (destinationType == Object.class) {
            return (T)value;
        }
        TypeConverter<T> converter = this.lookup(destinationType);
        if (converter != null) {
            return converter.convert(value);
        }
        if (value == null) {
            return null;
        }
        if (ClassUtil.isInstanceOf(value, destinationType)) {
            return (T)value;
        }
        if (destinationType.isArray()) {
            ArrayConverter arrayConverter = new ArrayConverter(this, destinationType.getComponentType());
            return (T)arrayConverter.convert(value);
        }
        if (destinationType.isEnum()) {
            T[] enums = destinationType.getEnumConstants();
            String valStr = value.toString();
            for (T e : enums) {
                if (!e.toString().equals(valStr)) continue;
                return e;
            }
        }
        if (ClassUtil.isTypeOf(destinationType, Collection.class)) {
            CollectionConverter<Object> collectionConverter = new CollectionConverter<Object>(this, destinationType, Object.class);
            return (T)collectionConverter.convert(value);
        }
        throw new TypeConversionException("Conversion failed of input type: " + value.getClass() + " into: " + destinationType.getName());
    }

    public <C extends Collection<T>, T> C convertToCollection(Object value, Class<? extends Collection> destinationType, Class<T> componentType) {
        if (value == null) {
            return null;
        }
        if (ClassUtil.isInstanceOf(value, destinationType)) {
            return (C)((Collection)value);
        }
        CollectionConverter<Object> collectionConverter = componentType == null ? new CollectionConverter<Object>(destinationType, Object.class) : new CollectionConverter<T>(destinationType, componentType);
        return (C)collectionConverter.convert(value);
    }
}

