/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.http.upload.impl;

import com.hypherionmc.simplerpc.jodd.http.upload.FileUpload;
import com.hypherionmc.simplerpc.jodd.http.upload.FileUploadFactory;
import com.hypherionmc.simplerpc.jodd.http.upload.MultipartRequestInputStream;
import com.hypherionmc.simplerpc.jodd.http.upload.impl.DiskFileUpload;
import com.hypherionmc.simplerpc.jodd.util.SystemUtil;
import java.io.File;
import java.io.IOException;

public class DiskFileUploadFactory
implements FileUploadFactory {
    protected File destFolder;
    protected int maxFileSize = 102400;

    public DiskFileUploadFactory() throws IOException {
        this(SystemUtil.info().getTempDir());
    }

    public DiskFileUploadFactory(String destFolder) throws IOException {
        this(destFolder, 102400);
    }

    public DiskFileUploadFactory(String destFolder, int maxFileSize) throws IOException {
        this.setUploadDir(destFolder);
        this.maxFileSize = maxFileSize;
    }

    public DiskFileUploadFactory setUploadDir(String destFolder) throws IOException {
        File destination;
        if (destFolder == null) {
            destFolder = SystemUtil.info().getTempDir();
        }
        if (!(destination = new File(destFolder)).exists()) {
            destination.mkdirs();
        }
        if (!destination.isDirectory()) {
            throw new IOException("Invalid destination folder: " + destFolder);
        }
        this.destFolder = destination;
        return this;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public DiskFileUploadFactory setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    @Override
    public FileUpload create(MultipartRequestInputStream input) {
        return new DiskFileUpload(input, this.destFolder, this.maxFileSize);
    }
}

