/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.exception;

import com.hypherionmc.simplerpc.jodd.io.IOUtil;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class ExceptionUtil {
    public static StackTraceElement[] getCurrentStackTrace() {
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (ste.length > 1) {
            StackTraceElement[] result = new StackTraceElement[ste.length - 1];
            System.arraycopy(ste, 1, result, 0, ste.length - 1);
            return result;
        }
        return ste;
    }

    public static StackTraceElement[] getStackTrace(Throwable t, String[] allow, String[] deny) {
        StackTraceElement[] st = t.getStackTrace();
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>(st.length);
        block0: for (StackTraceElement element : st) {
            String className = element.getClassName();
            if (allow != null) {
                boolean validElemenet = false;
                String[] stringArray = allow;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String filter = stringArray[i];
                    if (!className.contains(filter)) continue;
                    validElemenet = true;
                    break;
                }
                if (!validElemenet) continue;
            }
            if (deny != null) {
                for (String filter : deny) {
                    if (className.contains(filter)) continue block0;
                }
            }
            result.add(element);
        }
        st = new StackTraceElement[result.size()];
        return result.toArray(st);
    }

    public static StackTraceElement[][] getStackTraceChain(Throwable t, String[] allow, String[] deny) {
        ArrayList<StackTraceElement[]> result = new ArrayList<StackTraceElement[]>();
        while (t != null) {
            StackTraceElement[] stack = ExceptionUtil.getStackTrace(t, allow, deny);
            result.add(stack);
            t = t.getCause();
        }
        StackTraceElement[][] allStacks = new StackTraceElement[result.size()][];
        for (int i = 0; i < allStacks.length; ++i) {
            allStacks[i] = (StackTraceElement[])result.get(i);
        }
        return allStacks;
    }

    public static Throwable[] getExceptionChain(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.add(throwable);
        while ((throwable = throwable.getCause()) != null) {
            list.add(throwable);
        }
        Throwable[] result = new Throwable[list.size()];
        return list.toArray(result);
    }

    public static String exceptionStackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        IOUtil.close(pw);
        IOUtil.close(sw);
        return sw.toString();
    }

    public static String exceptionChainToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        while (t != null) {
            t.printStackTrace(pw);
            t = t.getCause();
        }
        IOUtil.close(pw);
        IOUtil.close(sw);
        return sw.toString();
    }

    public static String buildMessage(String message, Throwable cause) {
        if (cause != null) {
            cause = ExceptionUtil.getRootCause(cause);
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message).append("; ");
            }
            buf.append("<--- ").append(cause);
            return buf.toString();
        }
        return message;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        Throwable t = throwable;
        for (int i = 0; i < 1000; ++i) {
            cause = t.getCause();
            if (cause == null) {
                return t;
            }
            t = cause;
        }
        return throwable;
    }

    public static <T extends Throwable> T findCause(Throwable throwable, Class<T> cause) {
        while (throwable != null) {
            if (throwable.getClass().equals(cause)) {
                return (T)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public static SQLException rollupSqlExceptions(Collection<SQLException> exceptions) {
        SQLException parent = null;
        for (SQLException exception : exceptions) {
            if (parent != null) {
                exception.setNextException(parent);
            }
            parent = exception;
        }
        return parent;
    }

    public static void throwRuntimeException(Throwable throwable) {
        throw ExceptionUtil.wrapToRuntimeException(throwable);
    }

    public static String message(Throwable throwable) {
        String message = throwable.getMessage();
        if (StringUtil.isBlank(message)) {
            message = throwable.toString();
        }
        return message;
    }

    public static RuntimeException wrapToRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static Exception wrapToException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static Throwable unwrapThrowable(Throwable wrappedThrowable) {
        Throwable unwrapped = wrappedThrowable;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }
}

