/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.setup;

import com.mojang.brigadier.CommandDispatcher;
import dev.quarris.enigmaticgraves.command.RestoreGraveCommand;
import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.setup.Registry;
import java.util.LinkedList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticgraves")
public class CommonEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeathLast(LivingDeathEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!event.getEntity().m_9236_().f_46443_ && !event.isCanceled()) break block3;
            }
            return;
        }
        GraveManager.prepPlayerGrave(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerDrops(LivingDropsEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!event.getEntity().m_9236_().f_46443_) break block3;
            }
            return;
        }
        GraveManager.populatePlayerGrave(player, event.getDrops());
        GraveManager.spawnPlayerGrave(player);
    }

    @SubscribeEvent
    public static void spawnGraveFinder(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (!((Boolean)GraveConfigs.COMMON.spawnGraveFinder.get()).booleanValue()) {
            return;
        }
        ItemStack graveFinder = new ItemStack((ItemLike)Registry.GRAVE_FINDER_ITEM.get());
        LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)event.getEntity().m_9236_()).getGraveEntriesForPlayer(event.getEntity().m_20148_());
        if (entries == null || entries.isEmpty()) {
            return;
        }
        PlayerGraveEntry latestEntry = entries.getFirst();
        CompoundTag nbt = graveFinder.m_41784_();
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)latestEntry.gravePos));
        nbt.m_128362_("GraveUUID", latestEntry.graveUUID);
        event.getEntity().m_36356_(graveFinder);
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        RestoreGraveCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

