/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.typed.TypedMap;

public record ConditionalLoadable<T extends GenericLoaderRegistry.IHaveLoader>(GenericLoaderRegistry<T> registry, @Nullable T defaultIfFalse) implements RecordLoadable<T>
{
    @Override
    public T deserialize(JsonObject json, TypedMap context) {
        ICondition.IContext conditionContext = context.getOrDefault(ContextKey.CONDITION_CONTEXT, ICondition.IContext.TAGS_INVALID);
        if (CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)conditionContext)) {
            return (T)((GenericLoaderRegistry.IHaveLoader)this.registry.getIfPresent(json, "if_true"));
        }
        if (this.defaultIfFalse != null) {
            return (T)((GenericLoaderRegistry.IHaveLoader)this.registry.getOrDefault(json, "if_false", this.defaultIfFalse, context));
        }
        return (T)((GenericLoaderRegistry.IHaveLoader)this.registry.getIfPresent(json, "if_false", context));
    }

    @Override
    public void serialize(T object, JsonObject json) {
        ConditionalObject conditional = (ConditionalObject)object;
        json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])conditional.conditions()));
        json.add("if_true", this.registry.serialize((GenericLoaderRegistry.IHaveLoader)conditional.ifTrue()));
        GenericLoaderRegistry.IHaveLoader ifFalse = (GenericLoaderRegistry.IHaveLoader)conditional.ifFalse();
        if (ifFalse != this.defaultIfFalse) {
            json.add("if_false", this.registry.serialize(ifFalse));
        }
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        throw new UnsupportedOperationException("Conditional loadable should always resolve to a specific instance. This should never happen.");
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T value) {
        throw new UnsupportedOperationException("Conditional loadable should always resolve to a specific instance. This should never happen.");
    }

    public static interface ConditionalObject<T>
    extends GenericLoaderRegistry.IHaveLoader {
        public ICondition[] conditions();

        public T ifTrue();

        public T ifFalse();
    }
}

